/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.user.widget;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.addons.voicechat.api.client.user.moderate.Note;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.stream.user.AbstractAudioStream;
import net.labymod.addons.voicechat.core.listener.SettingListener;
import net.labymod.addons.voicechat.core.ui.activity.user.widget.ModerationWidget;
import net.labymod.addons.voicechat.core.ui.activity.user.widget.MuteTemplateEntryRenderer;
import net.labymod.addons.voicechat.core.ui.activity.user.widget.VisualBufferWidget;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.PopupWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.renderer.EntryRenderer;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.util.TimeUnit;
import net.labymod.api.util.time.TimeUtil;

@AutoWidget
public class UserSettingsWidget
extends FlexibleContentWidget {
    private final VoiceUser voiceUser;
    private final VoiceChat voiceChat;
    private final AudioStreamRegistry audioRegistry;
    private final String username;
    private ButtonWidget muteButtonWidget;
    private ComponentWidget statisticsWidget;
    private ButtonWidget sendReportButton;
    private DropdownWidget<MuteTemplate> templateWidget;
    private boolean reporting = false;

    public UserSettingsWidget(VoiceChat voiceChat, VoiceUser voiceUser, String username) {
        this.voiceUser = voiceUser;
        this.username = username;
        this.voiceChat = voiceChat;
        this.audioRegistry = voiceChat.referenceStorage().audioStreamRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Parent parent) {
        super.initialize(parent);
        VoiceUser voiceUser = this.voiceUser;
        synchronized (voiceUser) {
            if (this.reporting) {
                this.initializeReport();
            } else {
                this.initializeSettings();
            }
        }
    }

    private void initializeReport() {
        VerticalListWidget reportWrapperWidget = new VerticalListWidget();
        reportWrapperWidget.addId("report-wrapper");
        ComponentWidget reasonTitleWidget = ComponentWidget.i18n((String)"voicechat.activity.user.report");
        reasonTitleWidget.addId("reason-title");
        reportWrapperWidget.addChild((Widget)reasonTitleWidget);
        this.templateWidget = new DropdownWidget();
        this.templateWidget.setChangeListener(this::updateReportButton);
        this.templateWidget.setEntryRenderer((EntryRenderer)new MuteTemplateEntryRenderer());
        this.templateWidget.addId(new String[]{"input", "template-dropdown"});
        this.templateWidget.addAll((Object[])MuteTemplate.values());
        this.templateWidget.entries().remove((Object)MuteTemplate.CUSTOM);
        reportWrapperWidget.addChild(this.templateWidget);
        this.addFlexibleContent((Widget)reportWrapperWidget);
        HorizontalListWidget userFooterWidget = new HorizontalListWidget();
        userFooterWidget.addId("report-footer");
        this.sendReportButton = ButtonWidget.i18n((String)"labymod.ui.button.send");
        this.sendReportButton.addId("send-report-button");
        this.sendReportButton.setPressable(() -> {
            VoiceTransmitter transmitter = this.voiceChat.client().transmitter();
            MuteTemplate template = (MuteTemplate)((Object)((Object)this.templateWidget.getSelected()));
            transmitter.reportPlayer(this.voiceUser.getUniqueId(), template);
            this.labyAPI.minecraft().chatExecutor().displayClientMessage(((TextComponent)((TextComponent)Component.empty().append(VoiceChatAddon.VOICE_CHAT_PREFIX)).append((Component)Component.text((String)" "))).append(Component.translatable((String)"voicechat.commands.report.reported", (Component[])new Component[]{Component.text((String)this.username), Component.text((String)template.getDisplayName())}).color(NamedTextColor.RED)));
            this.labyAPI.minecraft().minecraftWindow().displayScreenRaw(null);
        });
        userFooterWidget.addEntry((Widget)this.sendReportButton);
        ButtonWidget cancelButton = ButtonWidget.i18n((String)"labymod.ui.button.cancel");
        cancelButton.addId("cancel-button");
        cancelButton.setPressable(() -> {
            this.reporting = false;
            this.reInitialize();
        });
        userFooterWidget.addEntry((Widget)cancelButton);
        this.addContent((Widget)userFooterWidget);
        this.updateReportButton(null);
    }

    private void updateReportButton(MuteTemplate template) {
        this.sendReportButton.setEnabled(template != null);
    }

    private void initializeSettings() {
        UUID uniqueId = this.voiceUser.getUniqueId();
        VerticalListWidget userSettingsWidget = new VerticalListWidget();
        userSettingsWidget.addId("user-settings");
        ComponentWidget volumeTitle = ComponentWidget.i18n((String)"voicechat.activity.user.volume");
        volumeTitle.addId("volume-slider-title");
        userSettingsWidget.addChild((Widget)volumeTitle);
        SliderWidget volumeSliderWidget = new SliderWidget(0.05f, newVolume -> {
            ((Map)this.voiceChat.configuration().playerVolumes().get()).put(uniqueId, Float.valueOf(newVolume));
            this.updateMuteButton();
        });
        SettingListener.applyDecibelFormatter(volumeSliderWidget);
        volumeSliderWidget.range(0.0f, 2.0f);
        volumeSliderWidget.setValue((double)this.voiceChat.configuration().getVolumeOf(uniqueId));
        volumeSliderWidget.addId("volume-slider");
        userSettingsWidget.addChild((Widget)volumeSliderWidget);
        HorizontalListWidget actionButtonsWidget = new HorizontalListWidget();
        actionButtonsWidget.addId("action-buttons");
        this.muteButtonWidget = ButtonWidget.component((Component)Component.empty());
        this.muteButtonWidget.addId("mute-button");
        this.muteButtonWidget.setPressable(() -> {
            float volume = this.voiceChat.configuration().getVolumeOf(uniqueId);
            boolean isMuted = volume == 0.0f;
            volumeSliderWidget.setValue(isMuted ? 1.0 : 0.0);
        });
        this.updateMuteButton();
        actionButtonsWidget.addEntry((Widget)this.muteButtonWidget);
        ButtonWidget reportButtonWidget = ButtonWidget.i18n((String)"voicechat.activity.user.report");
        reportButtonWidget.addId("report-button");
        reportButtonWidget.setPressable(() -> {
            this.reporting = true;
            this.reInitialize();
        });
        actionButtonsWidget.addEntry((Widget)reportButtonWidget);
        userSettingsWidget.addChild((Widget)actionButtonsWidget);
        VisualBufferWidget visualBufferWidget = new VisualBufferWidget(this.voiceChat, this.voiceUser.getUniqueId());
        visualBufferWidget.addId("sound-wave");
        userSettingsWidget.addChild((Widget)visualBufferWidget);
        ComponentWidget statisticsTitleWidget = ComponentWidget.i18n((String)"voicechat.activity.user.statistics.title");
        statisticsTitleWidget.addId("statistics-title");
        userSettingsWidget.addChild((Widget)statisticsTitleWidget);
        this.statisticsWidget = ComponentWidget.i18n((String)"voicechat.activity.user.statistics.noData");
        this.statisticsWidget.addId("statistics");
        userSettingsWidget.addChild((Widget)this.statisticsWidget);
        if (this.voiceChat.referenceStorage().voiceConnector().isStaff() && ((Boolean)this.voiceChat.configuration().modView().get()).booleanValue()) {
            TextComponent component;
            FlexibleContentWidget noteTable = new FlexibleContentWidget();
            noteTable.addId("note-table");
            ComponentWidget penWidget = ComponentWidget.text((String)"\u270e");
            penWidget.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.user.notes.title", (Component[])new Component[0]));
            penWidget.addId("pen");
            penWidget.setPressable(() -> {
                TextFieldWidget fieldWidget = new TextFieldWidget();
                PopupWidget.builder().title((Component)Component.translatable((String)"voicechat.activity.user.notes.title", (Component[])new Component[0])).widgetSupplier(() -> fieldWidget).confirmCallback(() -> {
                    String note = fieldWidget.getText();
                    if (note.length() < 3) {
                        return;
                    }
                    this.voiceChat.client().transmitter().addPlayerNote(this.voiceUser.getUniqueId(), note);
                    this.reInitialize();
                }).build().displayInOverlay();
            });
            noteTable.addContent((Widget)penWidget);
            List<Note> notes = this.voiceUser.getNotes();
            if (notes.isEmpty()) {
                component = Component.translatable((String)"voicechat.activity.user.notes.noData", (TextColor)NamedTextColor.RED);
            } else {
                component = Component.empty();
                for (Note note : notes) {
                    component.append((Component)Component.text((String)"- ")).append((Component)Component.text((String)note.getNote(), (TextColor)NamedTextColor.GOLD)).append((Component)Component.newline()).hoverEvent(HoverEvent.showText((Component)Component.text((String)(note.getNoteByName() + ", " + ModerationWidget.DATE_FORMAT.format(note.getTime())))));
                }
            }
            ComponentWidget noteWidget = ComponentWidget.component((Component)component);
            noteWidget.addId("note");
            ScrollWidget noteScrollWidget = new ScrollWidget((Widget)noteWidget, ListSession.create());
            noteScrollWidget.addId("note-scroll");
            noteTable.addFlexibleContent((Widget)noteScrollWidget);
            userSettingsWidget.addChild((Widget)noteTable);
        }
        this.addFlexibleContent((Widget)userSettingsWidget);
        DivWidget userFooterWidget = new DivWidget();
        userFooterWidget.addId("user-footer");
        ButtonWidget doneButton = ButtonWidget.i18n((String)"labymod.ui.button.done");
        doneButton.addId("done-button");
        doneButton.setPressable(() -> {
            Activity activity = (Activity)this.getRoot();
            activity.displayPreviousScreen();
        });
        userFooterWidget.addChild((Widget)doneButton);
        this.addContent((Widget)userFooterWidget);
    }

    public void tick() {
        super.tick();
        AudioStream audioStream = this.audioRegistry.getStreams().get(this.voiceUser.getUniqueId());
        if (audioStream instanceof AbstractAudioStream) {
            AbstractAudioStream stream = (AbstractAudioStream)audioStream;
            long rxSize = stream.getRxSize();
            long txSize = stream.getTxSize();
            int rxPackets = stream.getRxPackets();
            int txPackets = stream.getTxPackets();
            long duration = TimeUtil.getCurrentTimeMillis() - stream.getTimeCreation();
            this.statisticsWidget.setComponent((Component)Component.text((String)String.format("RX: %s, %s packets\nTX: %s, %s packets\nDuration: %s", this.formatBytes(rxSize), rxPackets, this.formatBytes(txSize), txPackets, TimeUnit.parseToString((long)duration))));
        }
    }

    private void updateMuteButton() {
        if (this.muteButtonWidget != null) {
            float volume = this.voiceChat.configuration().getVolumeOf(this.voiceUser.getUniqueId());
            boolean globalMutedForClient = this.voiceUser.isMutedForClient();
            boolean isMuted = volume == 0.0f || globalMutedForClient;
            this.muteButtonWidget.updateComponent(Component.translatable((String)("voicechat.activity.user." + (isMuted ? "unmute" : "mute")), (Component[])new Component[0]).color(isMuted ? NamedTextColor.RED : NamedTextColor.WHITE));
            if (globalMutedForClient) {
                this.muteButtonWidget.setHoverComponent(Component.translatable((String)"voicechat.activity.user.unmuteAsFriend", (Component[])new Component[0]).argument(Component.text((String)ModerationWidget.DATE_FORMAT.format(new Date(this.voiceUser.getMute().getTimeEnd()))).color(NamedTextColor.YELLOW)).color(NamedTextColor.GRAY));
            }
            this.muteButtonWidget.setEnabled(!globalMutedForClient);
            this.muteButtonWidget.reInitialize();
        }
    }

    private String formatBytes(long length) {
        if (length < 1024L) {
            return length + "B";
        }
        if (length < 0x100000L) {
            return length / 1024L + "KB";
        }
        if (length < 0x40000000L) {
            return length / 0x100000L + "MB";
        }
        return length / 0x40000000L + "GB";
    }

    public void setReporting(boolean reporting) {
        this.reporting = reporting;
    }
}

