/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.config.activation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.labymod.addons.voicechat.api.ClientVoiceState;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.ui.activity.rules.VoiceChatRulesActivity;
import net.labymod.addons.voicechat.core.ui.config.activation.VolumeIndicatorWidget;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.configuration.settings.accessor.SettingAccessor;
import net.labymod.api.configuration.settings.annotation.SettingElement;
import net.labymod.api.configuration.settings.annotation.SettingFactory;
import net.labymod.api.configuration.settings.annotation.SettingWidget;
import net.labymod.api.configuration.settings.widget.WidgetFactory;
import net.labymod.api.util.TextFormat;

@AutoWidget
@SettingWidget
@Link(value="sensitivity.lss")
public class SensitivityWidget
extends FlexibleContentWidget {
    private boolean testing;
    private ButtonWidget buttonWidget;
    private ClientVoiceState initializedState;

    public void initialize(Parent parent) {
        super.initialize(parent);
        ClientVoiceState state = VoiceChatAddon.INSTANCE.clientVoiceState();
        VolumeIndicatorWidget indicatorWidget = new VolumeIndicatorWidget(this);
        indicatorWidget.addId("indicator");
        this.addFlexibleContent((Widget)indicatorWidget);
        boolean testAvailable = state.isDeviceFunctional();
        this.buttonWidget = new ButtonWidget();
        this.buttonWidget.addId("button");
        this.buttonWidget.setHoverComponent(Component.translatable((String)(testAvailable ? "voicechat.widgets.voiceActivationSensitivity.description" : "voicechat.overlay.status." + TextFormat.SNAKE_CASE.toLowerCamelCase(state.name())), (Component[])new Component[0]).color(testAvailable ? NamedTextColor.WHITE : NamedTextColor.RED));
        this.buttonWidget.setEnabled(testAvailable);
        this.buttonWidget.setPressable(() -> this.updateTesting(!this.testing));
        this.addContent((Widget)this.buttonWidget);
        this.updateTesting(false);
        this.initializedState = state;
    }

    public void tick() {
        super.tick();
        ClientVoiceState state = VoiceChatAddon.INSTANCE.clientVoiceState();
        if (this.initializedState != state) {
            this.reInitialize();
        }
    }

    private void updateTesting(boolean testing) {
        if (testing && !VoiceChatAddon.INSTANCE.hasAcceptedRules()) {
            VoiceChatRulesActivity.create(activity -> {
                if (activity == null) {
                    return;
                }
                Minecraft minecraft = Laby.labyAPI().minecraft();
                minecraft.minecraftWindow().displayScreen((ScreenInstance)activity);
            });
            return;
        }
        this.testing = testing;
        this.buttonWidget.updateComponent((Component)Component.translatable((String)(testing ? "voicechat.widgets.voiceActivationSensitivity.stop" : "voicechat.widgets.voiceActivationSensitivity.test"), (TextColor)(testing ? NamedTextColor.RED : NamedTextColor.WHITE)));
        VoiceChatAddon.INSTANCE.setTestingMicrophone(testing);
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void dispose() {
        super.dispose();
        if (this.initialized && this.testing) {
            this.updateTesting(false);
        }
    }

    @SettingFactory
    public static class Factory
    implements WidgetFactory<SensitivitySetting, SensitivityWidget> {
        public SensitivityWidget[] create(Setting setting, SensitivitySetting annotation, SettingAccessor accessor) {
            return new SensitivityWidget[]{new SensitivityWidget()};
        }

        public Class<?>[] types() {
            return new Class[0];
        }
    }

    @SettingElement(extended=true)
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SensitivitySetting {
    }
}

