/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.config.activation;

import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioFrame;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.audio.util.Sample;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.ui.config.activation.SensitivityWidget;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.states.GuiRectangleRenderState;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.util.ColorUtil;
import net.labymod.api.util.bounds.Rectangle;
import net.labymod.api.util.color.format.ColorFormat;
import net.labymod.api.util.math.MathHelper;

@AutoWidget
public class VolumeIndicatorWidget
extends SimpleWidget {
    private final SensitivityWidget testWidget;
    private final AudioStreamRegistry audioStreamRegistry;
    private final VoiceChatConfiguration configuration;
    private double db = -127.0;

    public VolumeIndicatorWidget(SensitivityWidget testWidget) {
        this.testWidget = testWidget;
        this.audioStreamRegistry = VoiceChatAddon.INSTANCE.referenceStorage().audioStreamRegistry();
        this.configuration = (VoiceChatConfiguration)VoiceChatAddon.INSTANCE.configuration();
    }

    public void renderWidget(ScreenContext context) {
        super.renderWidget(context);
        ScreenCanvas canvas = context.canvas();
        Bounds bounds = this.bounds();
        float padding = 2.0f;
        float tickWidth = 5.0f;
        float spaceWidth = 1.0f;
        int ticks = MathHelper.floor((float)((bounds.getWidth() - padding * 2.0f) / (tickWidth + spaceWidth)));
        float spacePerTick = (bounds.getWidth() - padding * 1.0f - (float)ticks * tickWidth) / ((float)ticks - 1.0f);
        int tickLevel = MathHelper.ceil((double)((double)ticks * Sample.decibelToPercentage(this.db)));
        int colorGreen = ColorFormat.ARGB32.pack(65280, 255);
        int colorRed = ColorFormat.ARGB32.pack(0xFF0000, 255);
        for (int i = 0; i < ticks; ++i) {
            int color;
            float x = bounds.getX() + (float)i * (tickWidth + spacePerTick);
            int n = color = this.testWidget.isTesting() ? 0x222222 : 0x282828;
            if (i < tickLevel && this.testWidget.isTesting()) {
                float percent = (float)i / (float)ticks;
                color = ColorUtil.lerp((int)colorRed, (int)colorGreen, (float)percent);
            }
            canvas.submitRect((Rectangle)Rectangle.absolute((float)(x + padding), (float)(bounds.getY() + padding), (float)(x + tickWidth), (float)(bounds.getBottom() - padding)), ColorFormat.ARGB32.pack(color, 255));
            canvas.submitOutlineRect((Rectangle)Rectangle.absolute((float)(x + padding), (float)(bounds.getY() + padding), (float)(x + tickWidth), (float)(bounds.getBottom() - padding)), 1.0f, 0x50000000, 0x50000000);
        }
        double db = (Double)this.configuration.voiceActivationSensitivity().get();
        float x = (float)((double)bounds.getWidth() * Sample.decibelToPercentage(db));
        canvas.submitGuiRect((Rectangle)Rectangle.absolute((float)(x - 0.5f), (float)(bounds.getY() - 1.0f), (float)(x + 0.5f), (float)(bounds.getBottom() + 1.0f)), GuiRectangleRenderState.RectConfig.builder().setArgb(ColorFormat.ARGB32.pack(0xFFFFFF, 255)).build());
        for (int i = 1; i < 5; ++i) {
            canvas.submitGuiRect((Rectangle)Rectangle.absolute((float)(x - 0.5f * (float)i), (float)(bounds.getY() - 1.0f - (float)i), (float)(x + 0.5f * (float)i), (float)(bounds.getY() - (float)i)), GuiRectangleRenderState.RectConfig.builder().setArgb(ColorFormat.ARGB32.pack(0xFFFFFF, 255)).build());
        }
    }

    public void tick() {
        super.tick();
        AudioStream stream = this.audioStreamRegistry.getClientStream();
        if (stream == null) {
            this.db = -127.0;
            return;
        }
        AudioFrame data = stream.getLastFrame();
        if (data != null) {
            short[] samples = data.buffer();
            this.db = Sample.getDecibel(samples, 0, samples.length);
        }
    }

    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        if (mouseButton == MouseButton.LEFT) {
            this.setVoiceActivityDetectionLevel(mouse.getX(), mouse.getY());
            return true;
        }
        return super.mouseClicked(mouse, mouseButton);
    }

    public boolean mouseDragged(MutableMouse mouse, MouseButton button, double deltaX, double deltaY) {
        if (button == MouseButton.LEFT) {
            this.setVoiceActivityDetectionLevel(mouse.getX(), mouse.getY());
            return true;
        }
        return super.mouseDragged(mouse, button, deltaX, deltaY);
    }

    private void setVoiceActivityDetectionLevel(int mouseX, int mouseY) {
        Bounds bounds = this.bounds();
        if (!bounds.isInRectangle((float)mouseX, (float)mouseY)) {
            return;
        }
        float tickWidth = 5.0f;
        float spaceWidth = 1.0f;
        float x = (float)mouseX - bounds.getX() + tickWidth + spaceWidth;
        if (x > bounds.getRight() - 5.0f) {
            return;
        }
        float percentage = x / bounds.getWidth();
        double db = Sample.percentageToDecibel(percentage);
        this.configuration.voiceActivationSensitivity().set((Object)db);
    }
}

