/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.tag;

import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.client.user.DefaultVoiceUser;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.tag.tags.NameTag;
import net.labymod.api.client.render.font.RenderableComponent;

public class ChannelTag
extends NameTag {
    private final VoiceChat voiceChat;
    private final VoiceUserRegistry registry;
    private final ChannelController channelController;

    public ChannelTag(VoiceChat voiceChat, VoiceUserRegistry registry, ChannelController channelController) {
        this.voiceChat = voiceChat;
        this.registry = registry;
        this.channelController = channelController;
    }

    protected RenderableComponent getRenderableComponent() {
        Channel channel;
        VoiceChatConfiguration config = this.voiceChat.configuration();
        if (!(this.entity instanceof Player) || !((Boolean)config.enabled().get()).booleanValue()) {
            return null;
        }
        if (!((Boolean)config.channelIndicatorBelowName().get()).booleanValue()) {
            return null;
        }
        VoiceUser user = this.registry.get(this.entity.getUniqueId());
        if (!(user instanceof DefaultVoiceUser)) {
            return null;
        }
        UUID channelId = user.getChannelId();
        if (!user.isCommunicating() || channelId.equals(this.channelController.getCurrentChannelId())) {
            return null;
        }
        String channelName = user.getChannelName();
        if (channelId.equals(LobbyChannel.ID) && (channel = this.channelController.index().getChannelByChannelId(channelId)) != null) {
            channelName = channel.getName();
        }
        if (channelName == null) {
            return RenderableComponent.of((Component)Component.translatable((String)"voicechat.tag.channel.unknown", (TextColor)NamedTextColor.AQUA));
        }
        return RenderableComponent.of((Component)Component.translatable((String)"voicechat.tag.channel.known", (TextColor)NamedTextColor.AQUA).argument((Component)Component.text((String)channelName, (TextColor)NamedTextColor.WHITE)));
    }

    public float getScale() {
        return 0.4f;
    }
}

