/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.tag;

import java.util.UUID;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.tag.tags.IconTag;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.reference.annotation.Referenceable;

@Singleton
@Referenceable
public class VoiceTag
extends IconTag {
    private final AudioStreamRegistry audioStreamRegistry;
    private final VoiceUserRegistry voiceUserRegistry;
    private final VoiceChat voiceChat;
    private final ChannelController channelController;

    public VoiceTag(VoiceChat voiceChat, AudioStreamRegistry audioStreamRegistry, VoiceUserRegistry voiceUserRegistry) {
        super(10.0f);
        this.audioStreamRegistry = audioStreamRegistry;
        this.voiceUserRegistry = voiceUserRegistry;
        this.voiceChat = voiceChat;
        this.channelController = voiceChat.referenceStorage().channelController();
    }

    public boolean isVisible() {
        if (!(this.entity instanceof Player)) {
            return false;
        }
        if (!((Boolean)this.voiceChat.configuration().enabled().get()).booleanValue()) {
            return false;
        }
        if (this.voiceChat.isTestingMicrophone()) {
            return false;
        }
        UUID uniqueId = this.entity.getUniqueId();
        return this.voiceUserRegistry.isCommunicating(uniqueId) || this.audioStreamRegistry.hasStream(uniqueId);
    }

    private AudioStreamState getState() {
        return this.audioStreamRegistry.getState(this.entity.getUniqueId(), false);
    }

    public Icon getIcon() {
        return this.getState().getIcon();
    }
}

