/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.channel;

import java.util.Objects;
import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.channel.util.Identifiable;
import net.labymod.addons.voicechat.api.channel.util.Index;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.util.StringUtil;
import net.labymod.voice.protocol.util.properties.ChannelProperties;
import net.labymod.voice.protocol.util.properties.ChannelVisibility;

public interface Channel
extends Identifiable {
    public String getName();

    public Index<ChannelUser> users();

    public ChannelProperties properties();

    public Icon getIcon();

    public Component getIconToolTip();

    public boolean isClientOwner();

    public boolean hasPermission(ChannelUser var1);

    public boolean hasClientPermission();

    public long getCreationTime();

    public boolean isDefault();

    public boolean hasSounds();

    default public boolean isOwner(ChannelUser user) {
        return this.isOwner(user.getId());
    }

    default public boolean isOwner(UUID id) {
        return Objects.equals(this.properties().getOwner(), id);
    }

    default public boolean matchesQuery(String query) {
        if ((query = query.trim()).isEmpty()) {
            return true;
        }
        if (StringUtil.containsIgnoreCase((String)this.getName(), (String)query)) {
            return true;
        }
        for (ChannelUser user : this.users().unsorted()) {
            if (!StringUtil.containsIgnoreCase((String)user.getName(), (String)query)) continue;
            return true;
        }
        return false;
    }

    default public boolean isVisibleForVisibility(ChannelVisibility filter) {
        return this.properties().getVisibility() == filter;
    }
}

