/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.device.task.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.audio.device.io.InputDevice;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.noise.NoiseFilter;
import net.labymod.addons.voicechat.api.audio.noise.NoiseFilterFactory;
import net.labymod.addons.voicechat.api.audio.opus.OpusEncoder;
import net.labymod.addons.voicechat.api.audio.opus.OpusFactory;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.util.Sample;
import net.labymod.addons.voicechat.api.audio.util.VoiceActivationType;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.api.generated.ReferenceStorage;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.device.task.AbstractAudioTask;
import net.labymod.api.client.session.Session;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.Nullable;

public class InputAudioTask
extends AbstractAudioTask {
    private final DeviceController deviceController;
    private final ReferenceStorage references;
    private final ChannelController channelController;
    private final VoiceChat voiceChat;
    private final VoiceChatConfiguration config;
    private final VoiceConnector connector;
    private final VoiceTransmitter transmitter;
    private final AudioStreamRegistry streamRegistry;
    private final int bufferSize;
    @Nullable
    private OpusEncoder encoder;
    @Nullable
    private NoiseFilter noiseFilter;
    private short[] buffer;
    private short[] prevBuffer;
    private int nextSequenceNumber = 0;
    private long timeLastVoiceActivationTriggered = 0L;
    private boolean prevBufferAvailable = false;

    public InputAudioTask(DeviceController deviceController, ReferenceStorage references, int bufferSize) {
        super(DeviceType.INPUT);
        this.deviceController = deviceController;
        this.references = references;
        this.channelController = references.channelController();
        this.voiceChat = references.voiceChat();
        this.config = this.voiceChat.configuration();
        this.connector = this.voiceChat.client();
        this.transmitter = this.connector.transmitter();
        this.streamRegistry = references.audioStreamRegistry();
        this.bufferSize = bufferSize;
    }

    @Override
    public void start() {
        try {
            NoiseFilterFactory noise = this.references.noiseFilterFactory();
            if (noise.isInitialized()) {
                this.noiseFilter = noise.create();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            OpusFactory opus = this.references.opusFactory();
            if (opus.isInitialized()) {
                this.encoder = opus.createEncoder();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.start();
    }

    @Override
    protected void process() {
        block12: {
            InputDevice device = this.deviceController.getSelectedInputDevice();
            if (!((Boolean)this.config.enabled().get()).booleanValue() || device == null || !device.isOpen()) {
                this.nextSequenceNumber = 0;
                return;
            }
            if (!device.isActive()) {
                device.start();
            }
            if (device.available() < this.bufferSize) {
                return;
            }
            if (this.buffer == null || this.buffer.length != this.bufferSize) {
                this.buffer = new short[this.bufferSize];
                this.prevBuffer = new short[this.bufferSize];
            }
            device.read(this.buffer, 0, this.buffer.length);
            double volume = ((Float)this.config.inputVolume().get()).floatValue();
            double decibel = Sample.sliderToDecibel(volume);
            double gain = Sample.decibelToGain(decibel);
            if (volume != 1.0) {
                for (int i = 0; i < this.buffer.length; ++i) {
                    this.buffer[i] = (short)((double)this.buffer[i] * gain);
                }
            }
            if (this.noiseFilter != null && !this.noiseFilter.isClosed() && ((Boolean)this.config.noiseSuppression().get()).booleanValue()) {
                try {
                    this.noiseFilter.apply(this.buffer);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (this.noiseFilter.isClosed()) break block12;
                    this.noiseFilter.close();
                }
            }
        }
        if (!this.voiceChat.isTestingMicrophone() && !this.canTransmitAudio()) {
            return;
        }
        if (this.encoder == null || this.encoder.isClosed()) {
            return;
        }
        if (this.nextSequenceNumber <= 0) {
            this.nextSequenceNumber = 0;
        }
        byte[] encoded = this.encoder.encode(this.buffer);
        int sequenceNumber = this.nextSequenceNumber++;
        this.sendAudioToServer(encoded, sequenceNumber);
    }

    private void sendAudioToServer(byte[] encoded, int sequenceNumber) {
        UUID uniqueId = VoiceChatAddon.getSessionId();
        this.streamRegistry.submit(uniqueId, encoded, sequenceNumber);
        if (this.connector.isConnected() && this.connector.isAuthenticated() && !this.voiceChat.isTestingMicrophone()) {
            ByteBuffer packetBuffer = ByteBuffer.allocate(encoded.length + 8);
            packetBuffer.putLong(sequenceNumber);
            packetBuffer.put(encoded);
            ((Buffer)packetBuffer).flip();
            this.transmitter.sendAudioChunk(packetBuffer.array());
        }
    }

    private boolean canTransmitAudio() {
        ChannelController channelController = this.channelController;
        if (channelController.isInputMuted() || channelController.isOutputMuted()) {
            return false;
        }
        Channel currentChannel = channelController.getCurrentChannel();
        Session session = this.connector.getSession();
        if (session != null && currentChannel != null && !currentChannel.properties().canTalk(session.getUniqueId())) {
            return true;
        }
        VoiceActivationType type = this.config.inputActivation().get();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case VoiceActivationType.PUSH_TO_TALK -> {
                this.prevBufferAvailable = false;
                yield this.voiceChat.isPushToTalkPressed();
            }
            case VoiceActivationType.VOICE_ACTIVATION -> {
                if (this.isVoiceActivated()) {
                    boolean prevBufferAvailable = this.prevBufferAvailable;
                    Sample.swap(this.buffer, this.prevBuffer);
                    this.prevBufferAvailable = true;
                    yield prevBufferAvailable;
                }
                System.arraycopy(this.buffer, 0, this.prevBuffer, 0, this.buffer.length);
                this.prevBufferAvailable = true;
                yield false;
            }
            case VoiceActivationType.CONTINUOUS -> {
                this.prevBufferAvailable = false;
                yield true;
            }
        };
    }

    private boolean isVoiceActivated() {
        boolean isVoiceDetected = Sample.isDecibelAbove(this.buffer, (Double)this.config.voiceActivationSensitivity().get());
        long currentTime = TimeUtil.getCurrentTimeMillis();
        long timeSinceLastVoiceActivation = currentTime - this.timeLastVoiceActivationTriggered;
        if (isVoiceDetected) {
            this.timeLastVoiceActivationTriggered = currentTime;
            return true;
        }
        return timeSinceLastVoiceActivation <= 500L;
    }

    @Override
    public void close() {
        super.close();
        InputDevice device = this.deviceController.getSelectedInputDevice();
        if (device != null && device.isOpen()) {
            try {
                device.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.encoder != null && !this.encoder.isClosed()) {
            this.encoder.close();
        }
        if (this.noiseFilter != null && !this.noiseFilter.isClosed()) {
            this.noiseFilter.close();
        }
    }

    @Override
    public long getProcessIntervalMs() {
        InputDevice device = this.deviceController.getSelectedInputDevice();
        return device == null ? 500L : device.getProcessIntervalMs();
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() && this.encoder != null && !this.encoder.isClosed();
    }

    @Override
    public String getTaskName() {
        return "Microphone";
    }
}

