/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player;

import net.labymod.addons.voicechat.api.audio.opus.OpusFactory;
import net.labymod.addons.voicechat.api.audio.stream.user.player.PlayerAudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.player.effect.AudioPostProcessor;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.core.audio.stream.user.DefaultUserAudioStream;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AmbientAudioPostProcessor;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultPlayerAudioStream
extends DefaultUserAudioStream
implements PlayerAudioStream {
    private static final long CLIENT_TALK_TIMEOUT = 500L;
    @NotNull
    private final Player player;

    public DefaultPlayerAudioStream(@NotNull Player player, @NotNull VoiceUser user, @NotNull OpusFactory opus) {
        super(user, opus);
        this.player = player;
    }

    @Override
    protected AudioPostProcessor createAudioPostProcessor() {
        return new AmbientAudioPostProcessor(this.player, this.voiceUser);
    }

    @Override
    public boolean canShutdown() {
        return super.canShutdown() || this.player.isDead();
    }

    @Override
    public boolean isTalking() {
        return this.timeLastHeartbeat + 500L > TimeUtil.getCurrentTimeMillis();
    }

    @Override
    @NotNull
    public Player player() {
        return this.player;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.player.getName();
    }
}

