/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client.user;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.moderate.Mute;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteCategory;
import net.labymod.addons.voicechat.api.client.user.moderate.Note;
import net.labymod.addons.voicechat.api.client.user.moderate.Report;
import net.labymod.addons.voicechat.api.event.moderation.VoiceUserMetaEvent;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.client.user.moderate.DefaultMute;
import net.labymod.addons.voicechat.core.client.user.moderate.DefaultMuteCategory;
import net.labymod.addons.voicechat.core.client.user.moderate.DefaultNote;
import net.labymod.addons.voicechat.core.client.user.moderate.DefaultReport;
import net.labymod.addons.voicechat.core.ui.activity.user.VoiceChatUserActivity;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.event.Event;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.labyconnect.protocol.model.friend.Friend;
import net.labymod.api.util.StringUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultVoiceUser
implements VoiceUser {
    private final UUID uniqueId;
    private final List<Report> reports = new ArrayList<Report>();
    private final List<Mute> mutes = new ArrayList<Mute>();
    private final List<Note> notes = new ArrayList<Note>();
    private final List<MuteCategory> muteCategories = new ArrayList<MuteCategory>();
    @NotNull
    private UUID channelId = LobbyChannel.ID;
    @Nullable
    private String channelName;
    @NotNull
    private DefaultMute mute = DefaultMute.none();
    @NotNull
    private Mute serverApiMute = DefaultMute.none();
    private Report highlightedReport = null;
    private boolean communicating;
    @ApiStatus.Internal
    private boolean globalAudio;
    @ApiStatus.Internal
    private boolean walkieTalkieFilter;

    public DefaultVoiceUser(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeta(JsonObject meta) {
        VoiceChatUserActivity userActivity;
        UUID uniqueId;
        DefaultVoiceUser defaultVoiceUser = this;
        synchronized (defaultVoiceUser) {
            this.mutes.clear();
            this.reports.clear();
            this.notes.clear();
            this.muteCategories.clear();
            this.channelId = LobbyChannel.ID;
            this.channelName = null;
            if (meta.has("channel")) {
                JsonObject channel = meta.getAsJsonObject("channel");
                this.channelId = UUID.fromString(channel.get("id").getAsString());
                JsonElement name = channel.get("name");
                String string = this.channelName = name == null ? null : name.getAsString();
            }
            if (meta.has("mutes")) {
                DefaultMute activeMute = null;
                JsonArray mutes = meta.getAsJsonArray("mutes");
                for (int i = 0; i < mutes.size(); ++i) {
                    JsonObject object = mutes.get(i).getAsJsonObject();
                    DefaultMute mute = new DefaultMute(object.get("time_start").getAsLong(), object.get("time_end").getAsLong(), object.get("reason").getAsString(), object.get("muted_by_name").getAsString(), object.has("unmuted_by_name") ? object.get("unmuted_by_name").getAsString() : null, object.has("main_username") ? object.get("main_username").getAsString() : null);
                    this.mutes.add(mute);
                    if (activeMute != null || !mute.isActive()) continue;
                    activeMute = mute;
                }
                this.mute = activeMute == null ? DefaultMute.none() : activeMute;
            } else if (meta.has("mute_time_end")) {
                long muteTimeEnd = meta.get("mute_time_end").getAsLong();
                if (meta.has("mute_reason")) {
                    String reason = meta.get("mute_reason").getAsString();
                    this.mute = DefaultMute.until(muteTimeEnd, reason);
                } else {
                    this.mute = DefaultMute.until(muteTimeEnd);
                }
            } else {
                this.mute = DefaultMute.none();
            }
            if (meta.has("reports")) {
                JsonArray reports = meta.getAsJsonArray("reports");
                for (int i = 0; i < reports.size(); ++i) {
                    JsonObject object = reports.get(i).getAsJsonObject();
                    this.reports.add(new DefaultReport(object.get("id").getAsInt(), object.get("reason").getAsString(), object.get("reported_by").getAsString(), object.get("reported_at").getAsLong(), object.get("server_address").getAsString(), object.get("tape_id") == null ? null : UUID.fromString(object.get("tape_id").getAsString())));
                }
            }
            if (meta.has("notes")) {
                JsonArray notes = meta.getAsJsonArray("notes");
                for (int i = 0; i < notes.size(); ++i) {
                    JsonObject object = notes.get(i).getAsJsonObject();
                    this.notes.add(new DefaultNote(object.get("id").getAsInt(), object.get("note").getAsString(), object.get("created_by_name").getAsString(), object.get("updated_at").getAsLong()));
                }
            }
            if (meta.has("mute_categories")) {
                JsonArray categories = meta.getAsJsonArray("mute_categories");
                for (int i = 0; i < categories.size(); ++i) {
                    JsonObject object = categories.get(i).getAsJsonObject();
                    this.muteCategories.add(new DefaultMuteCategory(object.get("identifier").getAsString(), object.get("factor").getAsFloat(), object.get("duration").getAsLong()));
                }
            }
            this.updateHighlightedReport();
        }
        Activity activity = Laby.references().activityController().findOpenActivity(a -> a instanceof VoiceChatUserActivity);
        if (activity != null && (uniqueId = (userActivity = (VoiceChatUserActivity)activity).getVoiceUser().getUniqueId()).equals(this.uniqueId)) {
            Laby.labyAPI().minecraft().executeNextTick(() -> ((VoiceChatUserActivity)userActivity).reload());
        }
        Laby.fireEvent((Event)new VoiceUserMetaEvent(this, meta));
    }

    public Report getHighlightedReport() {
        return this.highlightedReport;
    }

    private void updateHighlightedReport() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Report report : this.getReports()) {
            map.put(StringUtil.toLowercase((String)report.getReason()), map.getOrDefault(report.getReason(), 0) + 1);
        }
        int max = 0;
        String reason = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= max) continue;
            max = (Integer)entry.getValue();
            reason = (String)entry.getKey();
        }
        if (reason == null) {
            this.highlightedReport = null;
            return;
        }
        for (Report report : this.getReports()) {
            if (!StringUtil.toLowercase((String)report.getReason()).equals(reason)) continue;
            this.highlightedReport = report;
            return;
        }
        this.highlightedReport = null;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public List<Report> getReports() {
        return this.reports;
    }

    @Override
    public List<Mute> getMutes() {
        return this.mutes;
    }

    @Override
    public boolean isMuted() {
        return this.getMute().isActive();
    }

    @Override
    public List<Note> getNotes() {
        return this.notes;
    }

    @Override
    public List<MuteCategory> getMuteCategories() {
        return this.muteCategories;
    }

    @Override
    public boolean isMutedForClient() {
        if (this.isMuted()) {
            LabyConnectSession session = Laby.labyAPI().labyConnect().getSession();
            if (session == null) {
                return true;
            }
            Friend friend = session.getFriend(this.uniqueId);
            boolean isFriendsWithClient = friend != null && friend.isOnline();
            return !isFriendsWithClient;
        }
        return false;
    }

    @Override
    @NotNull
    public Mute getMute() {
        return !this.mute.isActive() ? this.serverApiMute : this.mute;
    }

    @Override
    public boolean isClient() {
        return this.uniqueId.equals(VoiceChatAddon.getSessionId());
    }

    @Override
    public void setCommunicating(boolean communicating) {
        this.communicating = communicating;
    }

    @Override
    public boolean isCommunicating() {
        return this.communicating || this.uniqueId.equals(VoiceChatAddon.getSessionId());
    }

    @Override
    public boolean isVisibleInProximity() {
        ClientWorld world = Laby.labyAPI().minecraft().clientWorld();
        return this.isCommunicating() && world != null && world.getPlayer(this.uniqueId).isPresent();
    }

    @Override
    public void setServerApiMute(Mute mute) {
        this.serverApiMute = mute;
    }

    @Override
    public void resetServerProperties() {
        this.serverApiMute = DefaultMute.none();
        this.globalAudio = false;
        this.walkieTalkieFilter = false;
    }

    @Override
    @NotNull
    public UUID getChannelId() {
        return this.channelId;
    }

    @Override
    @Nullable
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    @ApiStatus.Internal
    public boolean hasGlobalAudio() {
        return this.globalAudio;
    }

    @Override
    @ApiStatus.Internal
    public boolean hasWalkieTalkieFilter() {
        return this.walkieTalkieFilter;
    }

    @Override
    @ApiStatus.Internal
    public void setGlobalAudio(boolean globalAudio) {
        this.globalAudio = globalAudio;
    }

    @Override
    @ApiStatus.Internal
    public void setWalkieTalkieFilter(boolean walkieTalkieFilter) {
        this.walkieTalkieFilter = walkieTalkieFilter;
    }
}

