/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.listener;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.labymod.addons.voicechat.api.audio.util.Sample;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.device.DefaultDeviceController;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.LabyScreen;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.settings.SettingWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.configuration.settings.type.SettingElement;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.addon.lifecycle.AddonPostEnableEvent;
import net.labymod.api.event.client.world.WorldEnterEvent;
import net.labymod.api.event.labymod.config.ConfigurationVersionUpdateEvent;
import net.labymod.api.event.labymod.config.SettingInitializeEvent;
import net.labymod.api.event.labymod.config.SettingUpdateEvent;
import net.labymod.api.event.labymod.config.SettingWidgetInitializeEvent;

public class SettingListener {
    private final Map<String, SettingUpdater> updaters = new HashMap<String, SettingUpdater>();

    public SettingListener() {
        this.registerUpdater("settings.voicechat.focusedVolume", SettingListener::applyDecibelFormatter);
        this.registerUpdater("settings.voicechat.unfocusedVolume", SettingListener::applyDecibelFormatter);
        this.registerUpdater("settings.voicechat.surroundRange", slider -> slider.withFormatter(value -> Component.text((String)((int)value + " bl."))));
    }

    private void registerUpdater(String key, SettingUpdater<?> updater) {
        this.updaters.put(key, updater);
    }

    @Subscribe
    public void onAddonPostEnable(AddonPostEnableEvent event) {
        VoiceChatConfiguration configuration = (VoiceChatConfiguration)VoiceChatAddon.INSTANCE.configuration();
        configuration.alternativeAudioInterfaces().addChangeListener(aBoolean -> {
            DefaultReferenceStorage references = VoiceChatAddon.INSTANCE.referenceStorage();
            DefaultDeviceController controller = (DefaultDeviceController)references.deviceController();
            controller.registerDefaults();
            controller.updateDevices();
            LabyScreen screen = Laby.labyAPI().minecraft().minecraftWindow().currentLabyScreen();
            if (screen instanceof Activity) {
                ((Activity)screen).reload();
            }
        });
    }

    @Subscribe
    public void onWorldEnter(WorldEnterEvent event) {
        DefaultReferenceStorage references = VoiceChatAddon.INSTANCE.referenceStorage();
        DefaultDeviceController controller = (DefaultDeviceController)references.deviceController();
        controller.updateDevices();
    }

    @Subscribe
    public void onSettingInitialize(SettingInitializeEvent event) {
        Setting setting = event.setting();
        this.onSettingInitialize(setting);
    }

    @Subscribe
    public void onSettingWidgetInitialize(SettingWidgetInitializeEvent event) {
        for (Widget widget : event.getSettings()) {
            if (!(widget instanceof SettingWidget)) continue;
            SettingWidget setting = (SettingWidget)widget;
            this.onSettingInitialize(setting.setting());
        }
    }

    @Subscribe
    public void onSettingUpdate(SettingUpdateEvent event) {
        VoiceConnector connector;
        if (event.phase() != Phase.POST) {
            return;
        }
        this.onSettingInitialize((Setting)event.setting());
        SettingElement setting = event.setting();
        String id = setting.getPath();
        if (id.startsWith("settings.voicechat.enabled")) {
            connector = VoiceChatAddon.INSTANCE.referenceStorage().voiceConnector();
            if (!((Boolean)event.getValue()).booleanValue() && connector.isConnected()) {
                connector.disconnect("Voice chat disabled");
            }
        }
        if ((id.startsWith("settings.voicechat.useBackupServer") || id.startsWith("settings.voicechat.useTestServer")) && (connector = VoiceChatAddon.INSTANCE.referenceStorage().voiceConnector()).isConnected()) {
            connector.disconnect("Switching server");
        }
    }

    @Subscribe
    public void onConfigurationVersionUpdate(ConfigurationVersionUpdateEvent event) {
        if (event.getUsedVersion() <= 1) {
            JsonElement playerVolumes;
            JsonElement enabledHotkey;
            JsonObject meta;
            JsonObject jsonObject = event.getJsonObject();
            if (jsonObject.has("configMeta") && (meta = jsonObject.getAsJsonObject("configMeta")).has("enabled.hotkey") && !(enabledHotkey = meta.get("enabled.hotkey")).isJsonNull()) {
                jsonObject.addProperty("toggleMuteOutputKey", enabledHotkey.getAsString());
                meta.remove("enabled.hotkey");
            }
            if ((playerVolumes = jsonObject.get("playerVolumes")) != null && playerVolumes.isJsonObject()) {
                JsonObject playerVolumesObj = playerVolumes.getAsJsonObject();
                playerVolumesObj.entrySet().removeIf(entry -> ((JsonElement)entry.getValue()).getAsFloat() != 0.0f);
            }
            jsonObject.remove("inputVolume");
            jsonObject.remove("outputVolume");
            event.setJsonObject(jsonObject);
        }
    }

    private void onSettingInitialize(Setting setting) {
        SettingUpdater updater = this.updaters.get(setting.getPath());
        if (updater == null) {
            return;
        }
        Widget[] widgets = setting.asElement().getWidgets();
        if (widgets.length == 0) {
            return;
        }
        updater.update(widgets[0]);
    }

    public static void applyDecibelFormatter(SliderWidget slider) {
        slider.withFormatter(value -> {
            float factor = slider.getValue();
            if (factor <= 0.0f) {
                return Component.text((String)"Mute", (TextColor)NamedTextColor.DARK_GRAY);
            }
            double decibel = Sample.sliderToDecibel(factor);
            String prefix = decibel > 0.0 ? "+" : "";
            String formatted = prefix + (int)decibel;
            return Component.text((String)(formatted + " dB"), (TextColor)(value > 1.5f ? NamedTextColor.RED : NamedTextColor.WHITE));
        });
    }

    private static interface SettingUpdater<T extends Widget> {
        public void update(T var1);
    }
}

