/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.listener;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.event.VoiceChatAuthenticatedEvent;
import net.labymod.addons.voicechat.api.event.channel.ClientChannelSwitchEvent;
import net.labymod.addons.voicechat.api.event.channel.UserHideEvent;
import net.labymod.addons.voicechat.api.event.channel.UserShowEvent;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.channel.AbstractChannel;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;
import net.labymod.api.event.client.network.server.SubServerSwitchEvent;
import net.labymod.api.event.client.world.DimensionChangeEvent;
import net.labymod.api.event.client.world.EntityDestructEvent;
import net.labymod.api.event.client.world.EntitySpawnEvent;
import net.labymod.api.event.client.world.WorldEnterEvent;
import net.labymod.api.event.client.world.WorldLeaveEvent;

public class VisiblePlayersListener {
    private final Minecraft minecraft = Laby.labyAPI().minecraft();
    private final VoiceConnector connector;
    private final ChannelController channelController;
    private boolean dirty;
    private long timeLastUpdate;

    public VisiblePlayersListener(DefaultReferenceStorage references) {
        this.connector = references.voiceConnector();
        this.channelController = references.channelController();
    }

    @Subscribe
    public void onVoiceChatAuthenticated(VoiceChatAuthenticatedEvent event) {
        this.dirty = true;
    }

    @Subscribe
    public void onChannelUserJoin(UserShowEvent event) {
        Channel currentChannel = this.channelController.getCurrentChannel();
        if (event.channel().equals(currentChannel)) {
            this.dirty = true;
        }
    }

    @Subscribe
    public void onWorldLeave(WorldLeaveEvent event) {
        this.dirty = true;
        VoiceChatAddon.INSTANCE.referenceStorage().audioStreamRegistry().shutdownAllStreams();
    }

    @Subscribe
    public void onWorldEnter(WorldEnterEvent event) {
        this.dirty = true;
    }

    @Subscribe
    public void onDimensionChange(DimensionChangeEvent event) {
        this.dirty = true;
    }

    @Subscribe
    public void onSubServerSwitch(SubServerSwitchEvent event) {
        this.dirty = true;
    }

    @Subscribe
    public void onChannelUserLeave(UserHideEvent event) {
        Channel currentChannel = this.channelController.getCurrentChannel();
        if (Objects.equals(event.channel(), currentChannel)) {
            this.dirty = true;
        }
    }

    @Subscribe
    public void onClientChannelSwitch(ClientChannelSwitchEvent event) {
        this.dirty = true;
    }

    @Subscribe
    public void onEntitySpawn(EntitySpawnEvent event) {
        if (event.entity() instanceof Player) {
            this.dirty = true;
        }
    }

    @Subscribe
    public void onEntityDestruct(EntityDestructEvent event) {
        if (event.entity() instanceof Player) {
            this.dirty = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTickEvent event) {
        AbstractChannel channel;
        if (!this.dirty || !this.connector.isAuthenticated()) {
            return;
        }
        long timePassed = System.currentTimeMillis() - this.timeLastUpdate;
        if (timePassed < 500L) {
            return;
        }
        this.timeLastUpdate = System.currentTimeMillis();
        this.dirty = false;
        HashSet<UUID> users = new HashSet<UUID>();
        if (this.minecraft.isIngame()) {
            ClientWorld clientWorld = this.minecraft.clientWorld();
            List players = clientWorld.getPlayers();
            for (Player player : players) {
                users.add(player.getUniqueId());
            }
        }
        if (this.channelController.isInCustomChannel() && (channel = (AbstractChannel)this.channelController.getCurrentChannel()) != null) {
            List<ChannelUser> unsorted = channel.users().unsorted();
            for (ChannelUser user : unsorted) {
                users.add(user.getId());
            }
        }
        this.connector.transmitter().sendVisiblePlayers(users.toArray(new UUID[0]));
    }
}

