/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.channel.widget;

import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.addons.voicechat.core.ui.activity.channel.popup.EditChannelPopup;
import net.labymod.addons.voicechat.core.ui.activity.channel.widget.VoiceChannelUserWidget;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.BoundsType;
import net.labymod.api.client.gui.screen.widget.context.ContextMenu;
import net.labymod.api.client.gui.screen.widget.context.ContextMenuEntry;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.SimpleAdvancedPopup;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.session.Session;
import net.labymod.voice.protocol.util.properties.ChannelProperties;

@AutoWidget
public class VoiceChannelWidget
extends SimpleWidget {
    private final Channel channel;
    private final ChannelController controller;
    private final VoiceConnector voiceConnector;
    private final VoiceTransmitter transmitter;
    private VerticalListWidget<Widget> listWidget;

    public VoiceChannelWidget(Channel channel) {
        this.channel = channel;
        this.setLazy(true);
        DefaultReferenceStorage reference = VoiceChatAddon.INSTANCE.referenceStorage();
        this.controller = reference.channelController();
        this.voiceConnector = reference.voiceConnector();
        this.transmitter = this.voiceConnector.transmitter();
        this.addId("channel");
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.listWidget = new VerticalListWidget();
        this.listWidget.addId("entries");
        HorizontalListWidget header = new HorizontalListWidget();
        header.addId("channel-header");
        header.setPressable(() -> {
            Session session = this.voiceConnector.getSession();
            if (session == null || this.channel.users().getById(session.getUniqueId()) != null) {
                return;
            }
            if (this.channel.properties().hasPassword() && !this.channel.hasClientPermission()) {
                TextFieldWidget passwordField = new TextFieldWidget();
                SimpleAdvancedPopup.builder().title((Component)Component.translatable((String)"voicechat.activity.channels.popup.password.title", (Component[])new Component[0])).widgets(widgets -> {
                    passwordField.addId("password-field");
                    passwordField.password(true);
                    widgets.addChild((Widget)passwordField);
                }).addButton(SimpleAdvancedPopup.SimplePopupButton.cancel()).addButton(SimpleAdvancedPopup.SimplePopupButton.confirm(button -> {
                    UUID userId = session.getUniqueId();
                    this.transmitter.sendMovePlayerToChannel(userId, this.channel.getId(), passwordField.getText());
                })).build().displayInOverlay();
            } else {
                UUID userId = session.getUniqueId();
                this.transmitter.sendMovePlayerToChannel(userId, this.channel.getId());
            }
        });
        if (this.channel.hasClientPermission()) {
            ContextMenu contextMenu = header.createContextMenu();
            if (VoiceChatAddon.INSTANCE.client().isStaff()) {
                contextMenu.with(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.resetTitle", (Component[])new Component[0])).clickHandler(entry -> {
                    VoiceTransmitter transmitter = this.voiceConnector.transmitter();
                    ChannelProperties properties = this.channel.properties().clone();
                    properties.setName("Channel");
                    transmitter.sendUpdateChannel(this.channel.getId(), properties);
                    return true;
                }).build());
            }
            contextMenu.with(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.popup.editChannel.title.edit", (Component[])new Component[0])).clickHandler(entry -> {
                EditChannelPopup.edit(this.channel).displayInOverlay();
                return true;
            }).build()).with(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.delete", (Component[])new Component[0])).clickHandler(entry -> {
                this.transmitter.sendDeleteChannel(this.channel.getId());
                return true;
            }).build());
        }
        IconWidget channelIcon = new IconWidget(this.channel.getIcon());
        channelIcon.addId("icon");
        channelIcon.setHoverComponent(this.channel.getIconToolTip());
        header.addEntry((Widget)channelIcon);
        ComponentWidget channelName = ComponentWidget.text((String)this.channel.getName());
        channelName.addId("name");
        String serverAddress = this.channel.properties().getServerAddress();
        if (serverAddress != null && !serverAddress.equals("unknown")) {
            channelName.setHoverComponent((Component)Component.text((String)serverAddress));
        }
        header.addEntry((Widget)channelName);
        if (this.channel.properties().isProximity()) {
            IconWidget proximityIcon = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_PROXIMITY);
            proximityIcon.addId(new String[]{"proximity", "badge"});
            proximityIcon.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.badges.proximity", (Component[])new Component[0]));
            header.addEntry((Widget)proximityIcon);
        }
        this.listWidget.addChild((Widget)header);
        for (ChannelUser user : this.channel.users().sorted()) {
            VoiceChannelUserWidget userWidget = new VoiceChannelUserWidget(this.channel, user);
            this.listWidget.addChild((Widget)userWidget);
        }
        this.addChild((Widget)this.listWidget);
    }

    public void addUser(ChannelUser user) {
        if (this.isInitialized()) {
            VoiceChannelUserWidget widget = this.getUserWidgetById(user.getId());
            if (widget != null) {
                return;
            }
            this.listWidget.addChildInitialized((Widget)new VoiceChannelUserWidget(this.channel, user));
            this.updateBounds();
        }
    }

    public void removeUser(UUID userId) {
        VoiceChannelUserWidget widget = this.getUserWidgetById(userId);
        if (widget != null) {
            this.listWidget.removeChild((Widget)widget);
            this.updateBounds();
        }
    }

    public VoiceChannelUserWidget getUserWidgetById(UUID userId) {
        if (!this.isInitialized()) {
            return null;
        }
        for (Widget widget : this.listWidget.getChildren()) {
            VoiceChannelUserWidget userWidget;
            ChannelUser channelUser;
            if (!(widget instanceof VoiceChannelUserWidget) || !(channelUser = (userWidget = (VoiceChannelUserWidget)widget).getChannelUser()).getId().equals(userId)) continue;
            return userWidget;
        }
        return null;
    }

    public int getSortingValue() {
        return (int)(this.channel.getCreationTime() / 1000L);
    }

    public float getContentHeight(BoundsType type) {
        return this.channel.users().unsorted().size() * 13 + 12;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

