/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.util;

import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.network.ClientPacketListener;
import net.labymod.api.client.network.NetworkPlayerInfo;
import net.labymod.api.labynet.LabyNetController;
import net.labymod.api.mojang.GameProfile;
import net.labymod.api.util.io.web.result.Result;
import net.labymod.api.util.io.web.result.ResultCallback;

public class User {
    private final UUID uniqueId;
    private final String userName;

    private User(UUID uniqueId, String userName) {
        this.uniqueId = uniqueId;
        this.userName = userName;
    }

    public static void loadAndBeautify(String input, ResultCallback<User> callback) {
        User.load(input, true, callback);
    }

    public static void load(String input, ResultCallback<User> callback) {
        User.load(input, false, callback);
    }

    private static void load(String userName, boolean beautify, ResultCallback<User> dummyUser) {
        if (userName.contains("-")) {
            UUID uniqueId = null;
            try {
                uniqueId = UUID.fromString(userName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uniqueId != null) {
                User.loadByUniqueId(uniqueId, dummyUser);
                return;
            }
        }
        User.loadByName(userName, beautify, dummyUser);
    }

    private static void loadByName(String userName, boolean beautify, ResultCallback<User> dummyUser) {
        User dummyUserFromNetworkPlayerInfos = User.getFromNetworkPlayerInfos(userName);
        if (dummyUserFromNetworkPlayerInfos != null) {
            dummyUser.acceptRaw((Object)dummyUserFromNetworkPlayerInfos);
            return;
        }
        LabyNetController labyNetController = Laby.references().labyNetController();
        labyNetController.loadUniqueIdByName(userName, result -> {
            if (!result.isPresent()) {
                if (result.hasException()) {
                    dummyUser.acceptException((Exception)result.exception());
                    return;
                }
                dummyUser.accept(Result.empty());
                return;
            }
            UUID uniqueId = (UUID)result.get();
            String name = beautify ? (String)labyNetController.loadNameByUniqueIdSync(uniqueId).getOrDefault((Object)userName) : userName;
            dummyUser.acceptRaw((Object)new User(uniqueId, name));
        });
    }

    private static void loadByUniqueId(UUID uniqueId, ResultCallback<User> callback) {
        User dummyUserFromNetworkPlayerInfos = User.getFromNetworkPlayerInfos(uniqueId);
        if (dummyUserFromNetworkPlayerInfos != null) {
            callback.acceptRaw((Object)dummyUserFromNetworkPlayerInfos);
            return;
        }
        LabyNetController labyNetController = Laby.references().labyNetController();
        labyNetController.loadNameByUniqueId(uniqueId, result -> {
            if (!result.isPresent()) {
                callback.acceptRaw((Object)new User(uniqueId, uniqueId.toString()));
                return;
            }
            callback.acceptRaw((Object)new User(uniqueId, (String)result.get()));
        });
    }

    private static User getFromNetworkPlayerInfos(String userName) {
        ClientPacketListener clientPacketListener = Laby.labyAPI().minecraft().getClientPacketListener();
        if (clientPacketListener == null) {
            return null;
        }
        for (NetworkPlayerInfo networkPlayerInfo : clientPacketListener.getNetworkPlayerInfos()) {
            GameProfile profile = networkPlayerInfo.profile();
            if (!userName.equalsIgnoreCase(profile.getUsername())) continue;
            return new User(profile.getUniqueId(), profile.getUsername());
        }
        return null;
    }

    private static User getFromNetworkPlayerInfos(UUID uniqueId) {
        ClientPacketListener clientPacketListener = Laby.labyAPI().minecraft().getClientPacketListener();
        if (clientPacketListener == null) {
            return null;
        }
        for (NetworkPlayerInfo networkPlayerInfo : clientPacketListener.getNetworkPlayerInfos()) {
            GameProfile profile = networkPlayerInfo.profile();
            if (uniqueId != profile.getUniqueId()) continue;
            return new User(profile.getUniqueId(), profile.getUsername());
        }
        return null;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public String getUserName() {
        return this.userName;
    }
}

