/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.javaxsound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice;
import net.labymod.addons.voicechat.javaxsound.JavaxDevice;
import org.jetbrains.annotations.NotNull;

public class JavaxOutputDevice
extends JavaxDevice<SourceDataLine>
implements OutputDevice {
    private byte[] buffer;

    public JavaxOutputDevice(@NotNull DeviceInformation information) {
        super(information);
    }

    @Override
    protected void openx(AudioFormat lineFormat, int bufferSize) throws LineUnavailableException {
        ((SourceDataLine)this.line).open(lineFormat, bufferSize);
    }

    @Override
    public void write(short[] in, int offset, int length) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        if (this.buffer == null || this.buffer.length != length * 2) {
            this.buffer = new byte[length * 2];
        }
        for (int i = 0; i < length; ++i) {
            short sample = in[offset + i];
            this.buffer[i * 2] = (byte)(sample & 0xFF);
            this.buffer[i * 2 + 1] = (byte)(sample >> 8 & 0xFF);
        }
        ((SourceDataLine)this.line).write(this.buffer, 0, length * 2);
    }

    @Override
    public void flush() {
        if (!this.isOpen()) {
            return;
        }
        ((SourceDataLine)this.line).flush();
    }

    @Override
    public long getProcessIntervalMs() {
        return 10L;
    }
}

