/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal.api;

import net.labymod.addons.voicechat.openal.api.ALError;
import org.lwjgl.openal.AL10;

public class ALBuffer {
    private final int[] ids;

    public ALBuffer(int amount) {
        this.ids = new int[amount];
        AL10.alGenBuffers((int[])this.ids);
        ALError.checkAL();
    }

    public void write(int index, FormatType format, short[] data, int frequency) {
        AL10.alBufferData((int)this.ids[index], (int)format.getValue(), (short[])data, (int)frequency);
        ALError.checkAL();
    }

    public void delete() {
        AL10.alDeleteBuffers((int[])this.ids);
        ALError.checkAL();
    }

    public int getId(int index) {
        return this.ids[index];
    }

    public int getSize() {
        return this.ids.length;
    }

    public static enum FormatType {
        MONO_8(4352),
        MONO_16(4353),
        STEREO_8(4354),
        STEREO_16(4355);

        private final int value;

        private FormatType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FormatType fromChannels(int channels, int bits) {
            if (channels == 1) {
                return bits == 8 ? MONO_8 : MONO_16;
            }
            return bits == 8 ? STEREO_8 : STEREO_16;
        }
    }
}

