/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal.api;

import java.io.IOException;
import java.nio.IntBuffer;
import net.labymod.addons.voicechat.openal.api.ALDevice;
import net.labymod.addons.voicechat.openal.api.ALError;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.EXTThreadLocalContext;

public class ALContext {
    private final ALDevice device;
    private long contextId;

    public ALContext(ALDevice device) throws IOException {
        this.device = device;
        this.contextId = ALC11.alcCreateContext((long)device.getId(), (IntBuffer)null);
        if (this.contextId == 0L) {
            throw new IOException("Failed to create context");
        }
        ALError.checkALC(this.device.getId());
    }

    public boolean setThreadContext() {
        boolean success = EXTThreadLocalContext.alcSetThreadContext((long)this.contextId);
        ALError.checkALC(this.device.getId());
        return success;
    }

    public void releaseThreadContext() {
        EXTThreadLocalContext.alcSetThreadContext((long)0L);
        ALError.checkALC(this.device.getId());
    }

    public void destroy() {
        ALC11.alcDestroyContext((long)this.contextId);
        ALError.checkALC(this.device.getId());
        this.contextId = 0L;
    }

    public boolean isDestroyed() {
        return this.contextId == 0L;
    }

    public long getContextId() {
        return this.contextId;
    }
}

