/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal.api;

import net.labymod.addons.voicechat.openal.api.ALBuffer;
import net.labymod.addons.voicechat.openal.api.ALError;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;

public class ALSource {
    private final int id = AL11.alGenSources();

    public ALSource() {
        ALError.checkAL();
    }

    public boolean exists() {
        boolean valid = AL11.alIsSource((int)this.id);
        ALError.checkAL();
        return valid;
    }

    public void setLooping(boolean enabled) {
        AL11.alSourcei((int)this.id, (int)4103, (int)ALSource.bool(enabled));
        ALError.checkAL();
    }

    public void setDistanceModel(DistanceModel model) {
        AL11.alDistanceModel((int)model.getValue());
        ALError.checkAL();
    }

    public void play() {
        AL11.alSourcePlay((int)this.id);
        ALError.checkAL();
    }

    public void pause() {
        AL11.alSourcePause((int)this.id);
        ALError.checkAL();
    }

    public void stop() {
        AL11.alSourceStop((int)this.id);
        ALError.checkAL();
    }

    public void rewind() {
        AL11.alSourceRewind((int)this.id);
        ALError.checkAL();
    }

    public State getState() {
        int state = AL10.alGetSourcei((int)this.id, (int)4112);
        ALError.checkAL();
        return State.fromValue(state);
    }

    public int getQueuedBuffers() {
        int amount = AL10.alGetSourcei((int)this.id, (int)4117);
        ALError.checkAL();
        return amount;
    }

    public int getProcessedBuffers() {
        int amount = AL10.alGetSourcei((int)this.id, (int)4118);
        ALError.checkAL();
        return amount;
    }

    public void setSampleOffset(int offset) {
        AL11.alSourcei((int)this.id, (int)4133, (int)offset);
        ALError.checkAL();
    }

    public int getSampleOffset() {
        int offset = AL11.alGetSourcei((int)this.id, (int)4133);
        ALError.checkAL();
        return offset;
    }

    public void queueBuffer(ALBuffer buffer, int index) {
        AL11.alSourceQueueBuffers((int)this.id, (int)buffer.getId(index));
        ALError.checkAL();
    }

    public void unqueueBuffer() {
        AL11.alSourceUnqueueBuffers((int)this.id);
        ALError.checkAL();
    }

    public void delete() {
        if (this.getState() == State.PLAYING) {
            this.stop();
        }
        AL11.alDeleteSources((int)this.id);
        ALError.checkAL();
    }

    public void setGain(float gain) {
        AL11.alSourcef((int)this.id, (int)4106, (float)gain);
        ALError.checkAL();
    }

    public void setMaxGain(float gain) {
        AL11.alSourcef((int)this.id, (int)4110, (float)gain);
        ALError.checkAL();
    }

    public void setMinGain(float gain) {
        AL11.alSourcef((int)this.id, (int)4109, (float)gain);
        ALError.checkAL();
    }

    public void setPitch(float pitch) {
        AL11.alSourcef((int)this.id, (int)4099, (float)pitch);
        ALError.checkAL();
    }

    public void setPosition(float x, float y, float z) {
        AL11.alSource3f((int)this.id, (int)4100, (float)x, (float)y, (float)z);
        ALError.checkAL();
    }

    public void setVelocity(float x, float y, float z) {
        AL11.alSource3f((int)this.id, (int)4102, (float)x, (float)y, (float)z);
        ALError.checkAL();
    }

    public void setDirection(float x, float y, float z) {
        AL11.alSource3f((int)this.id, (int)4101, (float)x, (float)y, (float)z);
        ALError.checkAL();
    }

    public void setRelative(boolean enabled) {
        AL11.alSourcei((int)this.id, (int)514, (int)ALSource.bool(enabled));
        ALError.checkAL();
    }

    public void setMaxDistance(float distance) {
        AL11.alSourcef((int)this.id, (int)4131, (float)distance);
        ALError.checkAL();
    }

    public void setRolloffFactor(float factor) {
        AL11.alSourcef((int)this.id, (int)4129, (float)factor);
        ALError.checkAL();
    }

    public void setReferenceDistance(float distance) {
        AL11.alSourcef((int)this.id, (int)4128, (float)distance);
        ALError.checkAL();
    }

    public void setListenerGain(float gain) {
        AL10.alListenerf((int)4106, (float)gain);
        ALError.checkAL();
    }

    public void setListenerPosition(float x, float y, float z) {
        AL10.alListener3f((int)4100, (float)x, (float)y, (float)z);
        ALError.checkAL();
    }

    public void setListenerVelocity(float x, float y, float z) {
        AL10.alListener3f((int)4102, (float)x, (float)y, (float)z);
        ALError.checkAL();
    }

    public void setListenerOrientation(float x, float y, float z, float xUp, float yUp, float zUp) {
        AL10.alListenerfv((int)4111, (float[])new float[]{x, y, z, xUp, yUp, zUp});
        ALError.checkAL();
    }

    public int getId() {
        return this.id;
    }

    private static int bool(boolean enabled) {
        return enabled ? 1 : 0;
    }

    public static enum DistanceModel {
        NONE(0),
        INVERSE(53249),
        INVERSE_CLAMPED(53250),
        LINEAR(53251),
        LINEAR_CLAMPED(53252),
        EXPONENT(53253),
        EXPONENT_CLAMPED(53254);

        private final int value;

        private DistanceModel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum State {
        INITIAL(4113),
        PLAYING(4114),
        PAUSED(4115),
        STOPPED(4116);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static State fromValue(int value) {
            for (State state : State.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            return null;
        }
    }
}

