/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.channel;

import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.util.Identifiable;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.user.GameUser;
import net.labymod.api.user.GameUserService;
import net.labymod.api.user.group.Group;
import net.labymod.api.user.group.GroupDisplayType;
import net.labymod.voice.protocol.util.properties.UserProperties;

public interface ChannelUser
extends Identifiable {
    default public String getName() {
        String name = this.properties().getName();
        return name == null ? "<unknown>" : name;
    }

    public UserProperties properties();

    public AudioStreamState getAudioStreamState(boolean var1);

    public boolean isClient();

    default public boolean isFriend() {
        LabyConnectSession session = Laby.labyAPI().labyConnect().getSession();
        if (session == null) {
            return false;
        }
        return session.getFriend(this.getId()) != null;
    }

    default public GameUser gameUser() {
        return Laby.references().gameUserService().gameUser(this.getId());
    }

    default public boolean canTalk(boolean voiceChannelContext) {
        return this.getAudioStreamState(voiceChannelContext).canTalk();
    }

    default public boolean canListen(boolean voiceChannelContext) {
        return this.getAudioStreamState(voiceChannelContext).canListen();
    }

    default public Component getDisplayName() {
        TextColor textColor = this.gameUser().displayColor();
        TextComponent component = Component.text((String)this.getName(), (TextColor)textColor);
        if (this.isClient()) {
            component.decorate(TextDecoration.BOLD);
        }
        return component;
    }

    default public int getPriorityForChannel(Channel channel) {
        UUID id = this.getId();
        GameUserService service = Laby.references().gameUserService();
        Group group = service.gameUser(id).visibleGroup();
        if (channel.isOwner(id)) {
            return 3;
        }
        if (group.isStaff()) {
            return 2;
        }
        if (group.isLabyModPlus() || group.getDisplayType() != GroupDisplayType.NONE && group.getDisplayType() != null) {
            return 1;
        }
        return 0;
    }
}

