/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.channel.channel.user;

import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.voice.protocol.util.properties.UserProperties;

public class DefaultChannelUser
implements ChannelUser {
    private final UUID id;
    private final UserProperties properties;

    public DefaultChannelUser(UUID id, UserProperties properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UserProperties properties() {
        return this.properties;
    }

    @Override
    public AudioStreamState getAudioStreamState(boolean voiceChannelContext) {
        DefaultReferenceStorage reference = VoiceChatAddon.INSTANCE.referenceStorage();
        return reference.audioStreamRegistry().getState(this.getId(), voiceChannelContext);
    }

    @Override
    public boolean isClient() {
        return this.getId().equals(VoiceChatAddon.getSessionId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultChannelUser that = (DefaultChannelUser)obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

