/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.channel.popup;

import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.AdvancedPopup;
import net.labymod.api.client.network.server.ServerData;
import net.labymod.api.client.session.Session;
import net.labymod.voice.protocol.util.properties.ChannelProperties;
import net.labymod.voice.protocol.util.properties.ChannelVisibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Link(value="voicechat-channels.lss")
public class EditChannelPopup
extends AdvancedPopup {
    private final UUID channelId;
    private final ChannelProperties properties;
    private final boolean edit;
    private final VoiceConnector voiceConnector;
    private final ChannelController channelController;
    private final VoiceUser clientUser;
    private TextFieldWidget nameField;
    private ButtonWidget saveButton;
    private DropdownWidget<ChannelVisibility> filterDropdown;
    private String passwordText;

    private EditChannelPopup(UUID channelId, ChannelProperties properties) {
        this.channelId = channelId;
        this.properties = properties;
        this.edit = channelId != null;
        this.passwordText = this.properties.hasPassword() ? "********" : "";
        VoiceChatAddon voiceChat = VoiceChatAddon.INSTANCE;
        this.voiceConnector = voiceChat.client();
        this.channelController = voiceChat.referenceStorage().channelController();
        Session session = voiceChat.client().getSession();
        if (session == null) {
            throw new IllegalStateException("Session is null");
        }
        this.clientUser = voiceChat.referenceStorage().voiceUserRegistry().getOrCreate(session.getUniqueId());
    }

    @Nullable
    public Widget initialize() {
        FlexibleContentWidget windowWidget = new FlexibleContentWidget();
        windowWidget.addId("edit-channel");
        ComponentWidget titleWidget = ComponentWidget.i18n((String)("voicechat.activity.channels.popup.editChannel.title." + (this.edit ? "edit" : "create")));
        titleWidget.addId("title");
        windowWidget.addContent((Widget)titleWidget);
        FlexibleContentWidget form = this.createFormWidget();
        windowWidget.addFlexibleContent((Widget)form);
        HorizontalListWidget buttons = new HorizontalListWidget();
        buttons.addId("buttons");
        ButtonWidget cancelButton = ButtonWidget.i18n((String)"labymod.ui.button.cancel");
        buttons.addId("cancel");
        cancelButton.setPressable(() -> this.close());
        buttons.addEntry((Widget)cancelButton);
        this.saveButton = ButtonWidget.i18n((String)(this.edit ? "labymod.ui.button.save" : "voicechat.activity.channels.popup.editChannel.create"));
        buttons.addId("save");
        this.saveButton.setPressable(this::submit);
        buttons.addEntry((Widget)this.saveButton);
        windowWidget.addContent((Widget)buttons);
        this.updateButtons();
        return windowWidget;
    }

    @NotNull
    private FlexibleContentWidget createFormWidget() {
        FlexibleContentWidget form = new FlexibleContentWidget();
        form.addId("form");
        VerticalListWidget labels = new VerticalListWidget();
        labels.addId("labels");
        this.addLabel((VerticalListWidget<Widget>)labels, "voicechat.activity.channels.popup.editChannel.name");
        this.addLabel((VerticalListWidget<Widget>)labels, "voicechat.activity.channels.popup.editChannel.password");
        this.addLabel((VerticalListWidget<Widget>)labels, "voicechat.activity.channels.popup.editChannel.visibility");
        if (this.properties.getVisibility() == ChannelVisibility.FRIENDS) {
            this.addLabel((VerticalListWidget<Widget>)labels, "voicechat.activity.channels.popup.editChannel.indirectFriends");
        }
        this.addLabel((VerticalListWidget<Widget>)labels, "voicechat.activity.channels.popup.editChannel.talkPower");
        if (this.properties.getVisibility() != ChannelVisibility.PUBLIC) {
            this.addLabel((VerticalListWidget<Widget>)labels, "voicechat.activity.channels.popup.editChannel.proximity");
        }
        form.addContent((Widget)labels);
        VerticalListWidget inputs = new VerticalListWidget();
        inputs.addId("inputs");
        boolean isGloballyMuted = this.clientUser.isMuted();
        this.nameField = new TextFieldWidget();
        this.nameField.setText(this.properties.getName());
        this.nameField.maximalLength(20);
        this.nameField.setEditable(!isGloballyMuted);
        if (isGloballyMuted) {
            this.nameField.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.popup.editChannel.nameMutedHint", (Component[])new Component[0]));
        }
        this.nameField.updateListener(name -> {
            this.properties.setName((String)name);
            this.updateButtons();
        });
        inputs.addChild((Widget)this.nameField);
        TextFieldWidget passwordField = new TextFieldWidget();
        passwordField.setText(this.passwordText);
        passwordField.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.popup.editChannel.passwordHint", (Component[])new Component[0]));
        passwordField.maximalLength(32);
        passwordField.password(true);
        passwordField.updateListener(plain -> {
            this.properties.setPasswordPlain((String)plain);
            this.passwordText = plain;
        });
        inputs.addChild((Widget)passwordField);
        this.filterDropdown = new DropdownWidget();
        this.filterDropdown.addAll((Object[])ChannelVisibility.VALUES);
        this.filterDropdown.setSelected((Object)this.properties.getVisibility());
        this.filterDropdown.setTranslationKeyPrefix("voicechat.activity.channels.visibility");
        this.filterDropdown.setChangeListener(channelVisibility -> {
            this.properties.setVisibility((ChannelVisibility)((Object)channelVisibility));
            this.widget().reInitialize();
        });
        inputs.addChild(this.filterDropdown);
        if (this.properties.getVisibility() == ChannelVisibility.FRIENDS) {
            CheckBoxWidget indirectFriendsCheckbox = new CheckBoxWidget();
            indirectFriendsCheckbox.setState(this.properties.isIndirectFriends() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
            indirectFriendsCheckbox.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.popup.editChannel.indirectFriendsHint", (Component[])new Component[0]));
            indirectFriendsCheckbox.setActionListener(() -> this.properties.setIndirectFriends(indirectFriendsCheckbox.state() == CheckBoxWidget.State.CHECKED));
            inputs.addChild((Widget)indirectFriendsCheckbox);
        }
        CheckBoxWidget talkPowerCheckbox = new CheckBoxWidget();
        talkPowerCheckbox.setState(this.properties.hasTalkPower() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        talkPowerCheckbox.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.popup.editChannel.talkPowerHint", (Component[])new Component[0]));
        talkPowerCheckbox.setActionListener(() -> this.properties.setTalkPower(talkPowerCheckbox.state() == CheckBoxWidget.State.CHECKED));
        inputs.addChild((Widget)talkPowerCheckbox);
        if (this.properties.getVisibility() != ChannelVisibility.PUBLIC) {
            CheckBoxWidget proximityCheckbox = new CheckBoxWidget();
            proximityCheckbox.setState(this.properties.isProximity() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
            proximityCheckbox.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.popup.editChannel.proximityHint", (Component[])new Component[0]));
            proximityCheckbox.setActionListener(() -> this.properties.setProximity(proximityCheckbox.state() == CheckBoxWidget.State.CHECKED && this.properties.getVisibility() != ChannelVisibility.PUBLIC));
            inputs.addChild((Widget)proximityCheckbox);
        }
        form.addFlexibleContent((Widget)inputs);
        return form;
    }

    private void addLabel(VerticalListWidget<Widget> labels, String key) {
        DivWidget label = new DivWidget();
        label.addId("label");
        ComponentWidget widget = ComponentWidget.i18n((String)key);
        label.addChild((Widget)widget);
        labels.addChild((Widget)label);
    }

    private void submit() {
        ServerData server = Laby.references().serverController().getCurrentServerData();
        if (server != null) {
            this.properties.setServerAddress(server.address().toString());
        }
        VoiceTransmitter transmitter = this.voiceConnector.transmitter();
        if (this.edit) {
            transmitter.sendUpdateChannel(this.channelId, this.properties);
        } else {
            transmitter.sendCreateChannel(this.properties);
        }
        this.close();
    }

    private void updateButtons() {
        this.saveButton.setEnabled(!this.nameField.getText().isEmpty());
    }

    public static EditChannelPopup edit(Channel channel) {
        return new EditChannelPopup(channel.getId(), channel.properties().clone());
    }

    public static EditChannelPopup create(ChannelVisibility currentFilter) {
        ChannelProperties properties = new ChannelProperties();
        properties.setName(VoiceChatAddon.getSessionName() + "'s Channel");
        properties.setOwner(VoiceChatAddon.getSessionId());
        properties.setVisibility(currentFilter);
        return new EditChannelPopup(null, properties);
    }
}

