/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.javaxsound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.io.InputDevice;
import net.labymod.addons.voicechat.javaxsound.JavaxDevice;
import org.jetbrains.annotations.NotNull;

public class JavaxInputDevice
extends JavaxDevice<TargetDataLine>
implements InputDevice {
    private byte[] buffer;

    public JavaxInputDevice(@NotNull DeviceInformation information) {
        super(information);
    }

    @Override
    protected void openx(AudioFormat lineFormat, int bufferSize) throws LineUnavailableException {
        ((TargetDataLine)this.line).open(lineFormat, bufferSize);
    }

    @Override
    public void read(short[] out, int offset, int length) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        int available = this.available();
        if (available < length) {
            throw new IllegalStateException("Not enough samples available: Available: " + available + ", requested: " + length);
        }
        if (this.buffer == null || this.buffer.length < length) {
            this.buffer = new byte[length * 2];
        }
        ((TargetDataLine)this.line).read(this.buffer, 0, this.buffer.length);
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            out[offset + i] = (short)(this.buffer[pos] & 0xFF | this.buffer[pos + 1] << 8);
        }
    }

    @Override
    public int available() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        return ((TargetDataLine)this.line).available() / 2;
    }

    @Override
    public long getProcessIntervalMs() {
        return 10L;
    }
}

