/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.voice.protocol.packet.client.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.labymod.voice.protocol.VoicePacket;
import net.labymod.voice.protocol.handler.ClientVoicePacketHandler;
import net.labymod.voice.protocol.type.ConnectionState;
import net.labymod.voice.protocol.type.EncryptType;
import net.labymod.voice.protocol.type.TransportType;

public class ClientAudioPacket
extends VoicePacket<ClientVoicePacketHandler> {
    private byte[] data;

    public ClientAudioPacket() {
        super(EncryptType.SYM, ConnectionState.CONNECTED, TransportType.UDP);
    }

    @Override
    public void write(ByteArrayOutputStream buffer, int protocolVersion) throws IOException {
        buffer.write(ClientAudioPacket.intToBytes(this.data.length));
        buffer.write(this.data);
    }

    @Override
    public void read(ByteArrayInputStream buffer, int protocolVersion) throws IOException {
        byte[] lenData = new byte[4];
        buffer.read(lenData);
        int len = ClientAudioPacket.byteArrayToInt(lenData);
        if (len > 1024) {
            throw new IllegalStateException("Packet too large: " + len + " bytes");
        }
        this.data = new byte[len];
        buffer.read(this.data);
    }

    @Override
    public void handle(ClientVoicePacketHandler handler) {
        handler.handleClientAudio(this);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

