/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.device;

import java.util.Collection;
import net.labymod.addons.voicechat.api.audio.device.Device;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.api.client.component.Component;

public interface AudioInterface {
    public String getIdentifier();

    public Component getDisplayName();

    public Collection<DeviceInformation> getInputDevices();

    public Collection<DeviceInformation> getOutputDevices();

    public DeviceInformation getDefaultInputDevice(Format var1);

    public DeviceInformation getDefaultOutputDevice(Format var1);

    public Device createDevice(DeviceInformation var1);

    public void clearInputDevices();

    public void clearOutputDevices();

    public void fetchInputDevices(Format var1);

    public void fetchOutputDevices(Format var1);

    default public void updateInputDevices(Format format) {
        this.clearInputDevices();
        this.fetchInputDevices(format);
    }

    default public void updateOutputDevices(Format format) {
        this.clearOutputDevices();
        this.fetchOutputDevices(format);
    }

    default public Collection<DeviceInformation> getDevices(DeviceType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case DeviceType.INPUT -> this.getInputDevices();
            case DeviceType.OUTPUT -> this.getOutputDevices();
        };
    }
}

