/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.device;

import java.util.Objects;
import net.labymod.addons.voicechat.api.audio.device.AudioInterface;

public class DeviceIdentifier {
    private final String interfaceId;
    private final String deviceId;

    public DeviceIdentifier(String identifier) {
        String[] parts = identifier.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid device identifier: " + identifier);
        }
        this.interfaceId = parts[0];
        this.deviceId = parts[1];
    }

    public DeviceIdentifier(String interfaceId, String deviceId) {
        this.interfaceId = interfaceId;
        this.deviceId = deviceId;
    }

    public DeviceIdentifier(AudioInterface interface0, String deviceId) {
        this.interfaceId = interface0.getIdentifier();
        this.deviceId = deviceId;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String toString() {
        return this.interfaceId + ":" + this.deviceId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceIdentifier that = (DeviceIdentifier)obj;
        return this.interfaceId.equals(that.interfaceId) && this.deviceId.equals(that.deviceId);
    }

    public int hashCode() {
        return Objects.hash(this.interfaceId, this.deviceId);
    }
}

