/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.channel;

import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelIndex;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Referenceable
public interface ChannelController {
    @NotNull
    public ChannelIndex index();

    @NotNull
    public UUID getCurrentChannelId();

    @Nullable
    public ChannelUser getClientChannelUser();

    public boolean isInputMuted();

    public boolean isOutputMuted();

    public void setInputMuted(boolean var1);

    public void setOutputMuted(boolean var1);

    public void sendClientProperties();

    public void subscribe();

    public boolean hasSubscribed();

    @Nullable
    default public Channel getCurrentChannel() {
        UUID currentChannelId = this.getCurrentChannelId();
        return this.index().getChannelByChannelId(currentChannelId);
    }

    default public boolean isInCustomChannel() {
        Channel currentChannel = this.getCurrentChannel();
        return currentChannel != null && !currentChannel.isDefault();
    }

    default public boolean isInProximity() {
        Channel channel = this.getCurrentChannel();
        return channel == null || channel.properties().isProximity();
    }
}

