/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core;

import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.ClientVoiceState;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.client.user.moderate.Mute;
import net.labymod.addons.voicechat.core.commands.VoiceFocusCommand;
import net.labymod.addons.voicechat.core.commands.VoiceMuteCommand;
import net.labymod.addons.voicechat.core.commands.VoiceReportCommand;
import net.labymod.addons.voicechat.core.commands.VoiceRulesCommand;
import net.labymod.addons.voicechat.core.commands.VoiceUnmuteCommand;
import net.labymod.addons.voicechat.core.commands.VoiceWarnCommand;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.addons.voicechat.core.listener.KeyListener;
import net.labymod.addons.voicechat.core.listener.NetworkListener;
import net.labymod.addons.voicechat.core.listener.SessionListener;
import net.labymod.addons.voicechat.core.listener.SettingListener;
import net.labymod.addons.voicechat.core.listener.TickListener;
import net.labymod.addons.voicechat.core.listener.VisiblePlayersListener;
import net.labymod.addons.voicechat.core.serverapi.VoiceChatServerApi;
import net.labymod.addons.voicechat.core.ui.activity.channel.VoiceChannelsActivity;
import net.labymod.addons.voicechat.core.ui.activity.rules.VoiceChatRulesActivity;
import net.labymod.addons.voicechat.core.ui.badge.VoiceBadge;
import net.labymod.addons.voicechat.core.ui.hudwidget.VoiceChatHudWidget;
import net.labymod.addons.voicechat.core.ui.hudwidget.VoiceChatIndicatorHudWidget;
import net.labymod.addons.voicechat.core.ui.interaction.VoiceChatBulletPoint;
import net.labymod.addons.voicechat.core.ui.overlay.MenuVoiceButtonOverlay;
import net.labymod.addons.voicechat.core.ui.overlay.VoiceFocusOverlay;
import net.labymod.addons.voicechat.core.ui.tag.ChannelTag;
import net.labymod.addons.voicechat.core.ui.tag.FocusedTag;
import net.labymod.addons.voicechat.core.ui.tag.ReportsTag;
import net.labymod.addons.voicechat.core.ui.tag.VoiceTag;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.chat.command.CommandService;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.entity.player.badge.BadgeRegistry;
import net.labymod.api.client.entity.player.badge.renderer.BadgeRenderer;
import net.labymod.api.client.entity.player.tag.PositionType;
import net.labymod.api.client.entity.player.tag.TagRegistry;
import net.labymod.api.client.entity.player.tag.renderer.TagRenderer;
import net.labymod.api.client.gui.hud.HudWidgetRegistry;
import net.labymod.api.client.gui.screen.LabyScreen;
import net.labymod.api.client.gui.screen.NamedScreen;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.types.IngameOverlayActivity;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.overlay.ScreenOverlay;
import net.labymod.api.client.gui.window.Window;
import net.labymod.api.client.session.Session;
import net.labymod.api.client.session.SessionAccessor;
import net.labymod.api.event.EventBus;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.gui.screen.ScreenOpenEvent;
import net.labymod.api.event.client.input.KeyEvent;
import net.labymod.api.event.client.lifecycle.ShutdownEvent;
import net.labymod.api.models.Implements;
import net.labymod.api.models.addon.annotation.AddonMain;
import org.jetbrains.annotations.NotNull;

@AddonMain
@Singleton
@Implements(value=VoiceChat.class)
public class VoiceChatAddon
extends LabyAddon<DefaultVoiceChatConfiguration>
implements VoiceChat {
    public static VoiceChatAddon INSTANCE;
    public static final Component VOICE_CHAT_PREFIX;
    private VoiceUserRegistry voiceUserRegistry;
    private AudioStreamRegistry audioStreamRegistry;
    private DeviceController deviceController;
    private ChannelController channelController;
    private TickListener tickListener;
    private boolean testingMicrophone = false;

    @Inject
    public VoiceChatAddon() {
        INSTANCE = this;
    }

    protected void preConfigurationLoad() {
        this.labyAPI().eventBus().registerListener((Object)new SettingListener());
    }

    protected void load() {
        EventBus eventBus = this.labyAPI().eventBus();
        DefaultReferenceStorage references = this.referenceStorage();
        eventBus.registerListener((Object)new SessionListener(references));
    }

    protected void enable() {
        ((DefaultVoiceChatConfiguration)this.configuration()).modView().visibilitySupplier(() -> this.client().isStaff());
        DefaultReferenceStorage references = this.referenceStorage();
        this.voiceUserRegistry = references.voiceUserRegistry();
        this.audioStreamRegistry = references.audioStreamRegistry();
        this.deviceController = references.deviceController();
        this.channelController = references.channelController();
        AudioStreamRegistry audioStreamRegistry = references.audioStreamRegistry();
        VoiceConnector voiceConnector = references.voiceConnector();
        EventBus eventBus = this.labyAPI().eventBus();
        eventBus.registerListener((Object)new NetworkListener(references));
        eventBus.registerListener((Object)new KeyListener());
        eventBus.registerListener((Object)new VoiceChatServerApi());
        eventBus.registerListener((Object)new VisiblePlayersListener(references));
        this.tickListener = new TickListener(references);
        eventBus.registerListener((Object)this.tickListener);
        this.registerSettingCategory();
        CommandService commandService = this.labyAPI().commandService();
        ((VoiceMuteCommand)commandService.register((Command)new VoiceMuteCommand(this, voiceConnector))).messagePrefix(VOICE_CHAT_PREFIX);
        ((VoiceUnmuteCommand)commandService.register((Command)new VoiceUnmuteCommand(voiceConnector))).messagePrefix(VOICE_CHAT_PREFIX);
        ((VoiceFocusCommand)commandService.register((Command)new VoiceFocusCommand(this))).messagePrefix(VOICE_CHAT_PREFIX);
        ((VoiceReportCommand)commandService.register((Command)new VoiceReportCommand(this, voiceConnector))).messagePrefix(VOICE_CHAT_PREFIX);
        ((VoiceRulesCommand)commandService.register((Command)new VoiceRulesCommand())).messagePrefix(VOICE_CHAT_PREFIX);
        ((VoiceWarnCommand)commandService.register((Command)new VoiceWarnCommand(this, voiceConnector))).messagePrefix(VOICE_CHAT_PREFIX);
        TagRegistry tagRegistry = this.labyAPI().tagRegistry();
        tagRegistry.register("VoiceTag", PositionType.RIGHT_TO_NAME, (TagRenderer)new VoiceTag(this));
        tagRegistry.register("VoiceReportsTag", PositionType.BELOW_NAME, (TagRenderer)new ReportsTag());
        tagRegistry.register("VoiceChannelTag", PositionType.BELOW_NAME, (TagRenderer)new ChannelTag(this));
        tagRegistry.register("VoiceFocusedTag", PositionType.ABOVE_NAME, (TagRenderer)new FocusedTag());
        BadgeRegistry badgeRegistry = Laby.references().badgeRegistry();
        badgeRegistry.register("VoiceBadge", net.labymod.api.client.entity.player.badge.PositionType.RIGHT_TO_NAME, (BadgeRenderer)new VoiceBadge(this, voiceConnector, this.voiceUserRegistry, audioStreamRegistry));
        this.labyAPI().interactionMenuRegistry().register((Object)new VoiceChatBulletPoint(this, this.voiceUserRegistry));
        this.labyAPI().ingameOverlay().registerActivity((IngameOverlayActivity)new VoiceFocusOverlay(this, this.referenceStorage().focusedUsers(), this.labyAPI()));
        Laby.references().screenOverlayHandler().registerOverlay((ScreenOverlay)new MenuVoiceButtonOverlay(this.channelController));
        HudWidgetRegistry registry = this.labyAPI().hudWidgetRegistry();
        registry.register((Object)new VoiceChatHudWidget(this, audioStreamRegistry));
        registry.register((Object)new VoiceChatIndicatorHudWidget(this));
    }

    protected Class<DefaultVoiceChatConfiguration> configurationClass() {
        return DefaultVoiceChatConfiguration.class;
    }

    @Override
    public boolean isPushToTalkPressed() {
        DefaultVoiceChatConfiguration configuration = (DefaultVoiceChatConfiguration)this.configuration();
        Minecraft minecraft = this.labyAPI().minecraft();
        if (!((Boolean)configuration.enabled().get()).booleanValue()) {
            return false;
        }
        if (!minecraft.isKeyPressed((Key)configuration.pushToTalkKey().get())) {
            return false;
        }
        LabyScreen currentScreen = Laby.labyAPI().minecraft().minecraftWindow().currentLabyScreen();
        return minecraft.isMouseLocked() || !this.channelController.isInProximity() || currentScreen instanceof VoiceChannelsActivity;
    }

    @Override
    public boolean isTestingMicrophone() {
        return this.testingMicrophone;
    }

    public void setTestingMicrophone(boolean testingMicrophone) {
        if (this.testingMicrophone == testingMicrophone) {
            return;
        }
        this.testingMicrophone = testingMicrophone;
        Session session = this.client().getSession();
        if (session != null) {
            this.audioStreamRegistry.shutdownStream(session.getUniqueId());
        }
    }

    public boolean hasAcceptedRules() {
        return (Long)((DefaultVoiceChatConfiguration)this.configuration()).timeRulesAccepted().get() >= VoiceChatRulesActivity.CURRENT_RULE_TIMESTAMP;
    }

    @Subscribe
    public void onScreenOpen(ScreenOpenEvent event) {
        this.setTestingMicrophone(false);
    }

    @Subscribe
    public void onShutdown(ShutdownEvent event) {
        this.client().disconnect("Game shutdown");
    }

    @Subscribe
    public void onKey(KeyEvent event) {
        DefaultVoiceChatConfiguration configuration;
        if (event.state() != KeyEvent.State.PRESS) {
            return;
        }
        Key pressedKey = event.key();
        if (pressedKey.equals((configuration = (DefaultVoiceChatConfiguration)this.configuration()).voiceChannelsKey().get())) {
            if (!this.client().isConnected() || !this.client().isAuthenticated()) {
                return;
            }
            Minecraft minecraft = this.labyAPI().minecraft();
            Window window = minecraft.minecraftWindow();
            if (!minecraft.isMouseLocked()) {
                return;
            }
            window.displayScreen((ScreenInstance)new VoiceChannelsActivity());
        }
        if (pressedKey.equals(configuration.toggleMuteInputKey().get()) || pressedKey.equals(configuration.toggleMuteOutputKey().get())) {
            ChannelController controller = this.referenceStorage().channelController();
            Minecraft minecraft = this.labyAPI().minecraft();
            if (controller.isInProximity()) {
                LabyScreen activity = minecraft.minecraftWindow().currentLabyScreen();
                if (!minecraft.isMouseLocked() && !(activity instanceof VoiceChannelsActivity)) {
                    return;
                }
            } else {
                Object screen = minecraft.minecraftWindow().getCurrentVersionedScreen();
                LabyScreen activity = minecraft.minecraftWindow().currentLabyScreen();
                if (!(minecraft.isMouseLocked() || NamedScreen.INGAME_MENU.isScreen(screen) || NamedScreen.MULTIPLAYER.isScreen(screen) || NamedScreen.MAIN_MENU.isScreen(screen) || activity instanceof VoiceChannelsActivity)) {
                    return;
                }
            }
            if (pressedKey.equals(configuration.toggleMuteInputKey().get())) {
                this.channelController.setInputMuted(!this.channelController.isInputMuted());
            } else {
                this.channelController.setOutputMuted(!this.channelController.isOutputMuted());
            }
        }
    }

    @Override
    public ClientVoiceState clientVoiceState() {
        if (!((Boolean)((DefaultVoiceChatConfiguration)this.configuration()).enabled().get()).booleanValue()) {
            return ClientVoiceState.DISABLED;
        }
        if (!this.hasAcceptedRules() && VoiceChatRulesActivity.CACHED_RULES != null) {
            return ClientVoiceState.RULES_NOT_ACCEPTED;
        }
        VoiceConnector client = this.client();
        if (client.getSession() == null || !client.getSession().isPremium()) {
            return ClientVoiceState.INVALID_SESSION;
        }
        if (!client.isConnected()) {
            return ClientVoiceState.NOT_CONNECTED;
        }
        if (!client.isAuthenticated()) {
            return ClientVoiceState.AUTHENTICATING;
        }
        if (!this.referenceStorage().opusFactory().isInitialized()) {
            return ClientVoiceState.OPUS_NOT_INITIALIZED;
        }
        if (!this.deviceController.isInputDeviceRunning()) {
            return ClientVoiceState.INPUT_DISABLED;
        }
        if (!this.deviceController.isOutputDeviceRunning()) {
            return ClientVoiceState.OUTPUT_DISABLED;
        }
        Minecraft minecraft = this.labyAPI().minecraft();
        SessionAccessor sessionAccessor = minecraft.sessionAccessor();
        if (sessionAccessor == null) {
            return ClientVoiceState.WRONG_SESSION;
        }
        Session session = sessionAccessor.getSession();
        if (session == null) {
            return ClientVoiceState.WRONG_SESSION;
        }
        if (this.channelController.isInProximity() && minecraft.isIngame()) {
            UUID sessionUUID = session.getUniqueId();
            ClientPlayer clientPlayer = minecraft.getClientPlayer();
            if (clientPlayer == null || !clientPlayer.getUniqueId().equals(sessionUUID)) {
                return ClientVoiceState.WRONG_SESSION;
            }
        }
        if (this.channelController.isOutputMuted()) {
            return ClientVoiceState.OUTPUT_MUTED;
        }
        if (this.channelController.isInputMuted()) {
            return ClientVoiceState.INPUT_MUTED;
        }
        Mute mute = this.voiceUserRegistry.getOrCreate(this.labyAPI().getUniqueId()).getMute();
        if (mute.isActive()) {
            return ClientVoiceState.INPUT_MUTED_GLOBAL;
        }
        return ClientVoiceState.READY;
    }

    @Override
    public VoiceConnector client() {
        return this.referenceStorage().voiceConnector();
    }

    public TickListener getTickListener() {
        return this.tickListener;
    }

    @Override
    public DefaultReferenceStorage referenceStorage() {
        return (DefaultReferenceStorage)this.getReferenceStorageAccessor();
    }

    @NotNull
    public static UUID getSessionId() {
        Session session = INSTANCE.client().getSession();
        return session != null ? session.getUniqueId() : Laby.labyAPI().getUniqueId();
    }

    @NotNull
    public static String getSessionName() {
        Session session = INSTANCE.client().getSession();
        return session != null ? session.getUsername() : Laby.labyAPI().getName();
    }

    static {
        VOICE_CHAT_PREFIX = ((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"VoiceChat", (TextColor)NamedTextColor.BLUE))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));
    }
}

