/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user;

import java.util.PriorityQueue;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.labymod.addons.voicechat.api.audio.opus.OpusDecoder;
import net.labymod.addons.voicechat.api.audio.opus.OpusFactory;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioFrame;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.player.effect.AudioPostProcessor;
import net.labymod.addons.voicechat.api.audio.util.Sample;
import net.labymod.addons.voicechat.api.audio.util.VisualBuffer;
import net.labymod.addons.voicechat.api.configuration.FocusedUsers;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamTalkingStateChangedEvent;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.stream.user.DefaultAudioFrame;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.event.Event;
import net.labymod.api.util.ThreadSafe;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAudioStream
implements AudioStream {
    private static final long TALK_TIMEOUT = 100L;
    private static final long SHUTDOWN_TIMEOUT = 3000L;
    private final Queue<Runnable> runnables = new ConcurrentLinkedDeque<Runnable>();
    private final Queue<AudioFrame> queue;
    private final VisualBuffer visualBuffer;
    protected final UUID id;
    private final OpusFactory opusFactory;
    private OpusDecoder decoder;
    private boolean closed;
    private final long timeCreation;
    protected long timeLastHeartbeat;
    private long txSize;
    private long rxSize;
    private int txPackets;
    private int rxPackets;
    private AudioFrame lastFrame;
    private boolean lastTalking = false;
    protected AudioPostProcessor postProcessor;

    public AbstractAudioStream(UUID id, OpusFactory opusFactory) {
        this.id = id;
        this.opusFactory = opusFactory;
        this.visualBuffer = new VisualBuffer();
        this.timeCreation = TimeUtil.getCurrentTimeMillis();
        this.queue = new PriorityQueue<AudioFrame>((o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return Long.compare(o1.getSegmentNumber(), o2.getSegmentNumber());
        });
    }

    @Override
    public void initialize() {
        this.decoder = this.opusFactory.createDecoder();
        this.postProcessor = this.createAudioPostProcessor();
        this.makeHeartbeat();
    }

    protected AudioPostProcessor createAudioPostProcessor() {
        return AudioPostProcessor.NONE;
    }

    @Override
    public int available() {
        int available = 0;
        for (AudioFrame frame : this.queue) {
            available += frame.available();
        }
        return available;
    }

    @Override
    public void read(short[] out, int offset, int length) {
        AudioFrame frame = this.queue.peek();
        if (frame == null) {
            throw new IllegalStateException("No frame available");
        }
        frame.read(out, offset, length);
        if (frame.available() == 0) {
            this.queue.remove(frame);
        }
    }

    @Override
    public void collect() {
        while (!this.runnables.isEmpty()) {
            Runnable poll = this.runnables.poll();
            if (poll == null) continue;
            poll.run();
        }
    }

    @Override
    public void tick() {
        this.postProcessor.tick();
        boolean talking = this.isTalking();
        if (talking != this.lastTalking) {
            this.lastTalking = talking;
            Laby.fireEvent((Event)new AudioStreamTalkingStateChangedEvent(this, talking));
        }
    }

    @Override
    public boolean isTalking() {
        return this.timeLastHeartbeat + 100L > TimeUtil.getCurrentTimeMillis();
    }

    @Override
    public boolean canShutdown() {
        boolean timeout = this.timeLastHeartbeat + 3000L < TimeUtil.getCurrentTimeMillis();
        return timeout && this.postProcessor.canClose();
    }

    private void makeHeartbeat() {
        this.timeLastHeartbeat = TimeUtil.getCurrentTimeMillis();
    }

    @Override
    public void queueEncodedData(byte[] encoded, long segmentNumber) {
        if (this.queue.size() > 15 || encoded.length == 0 || this.decoder == null || this.closed) {
            return;
        }
        short[] samples = this.decoder.decode(encoded);
        DefaultAudioFrame frame = new DefaultAudioFrame(samples, segmentNumber);
        this.runnables.add(() -> this.queue.add(frame));
        ThreadSafe.executeOnRenderThread(() -> this.visualBuffer.write(frame.buffer()));
        this.lastFrame = frame;
        this.makeHeartbeat();
    }

    @Override
    public void close() {
        this.queue.clear();
        this.runnables.clear();
        this.postProcessor.close();
        this.lastFrame = null;
        this.closed = true;
        if (this.decoder != null && !this.decoder.isClosed()) {
            this.decoder.close();
        }
    }

    @Override
    public VisualBuffer visualBuffer() {
        return this.visualBuffer;
    }

    public void incrementRX(long length) {
        this.rxSize += length;
        ++this.rxPackets;
    }

    public void incrementTX(long length) {
        this.txSize += length;
        ++this.txPackets;
    }

    public int getRxPackets() {
        return this.rxPackets;
    }

    public int getTxPackets() {
        return this.txPackets;
    }

    public long getRxSize() {
        return this.rxSize;
    }

    public long getTxSize() {
        return this.txSize;
    }

    public long getTimeCreation() {
        return this.timeCreation;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public double getVolume() {
        VoiceChatAddon voiceChat = VoiceChatAddon.INSTANCE;
        FocusedUsers focusedUsers = voiceChat.referenceStorage().focusedUsers();
        DefaultVoiceChatConfiguration config = (DefaultVoiceChatConfiguration)voiceChat.configuration();
        double decibel = Sample.sliderToDecibel(config.getVolumeOf(this.id)) + Sample.sliderToDecibel(((Float)config.outputVolume().get()).floatValue());
        if (focusedUsers.isActive()) {
            boolean isFocused = focusedUsers.isFocused(this.id);
            decibel += Sample.sliderToDecibel((isFocused ? (Float)config.focusVolumeIncrease().get() : (Float)config.focusVolumeDecrease().get()).floatValue());
        }
        return Sample.decibelToGain(decibel);
    }

    @Override
    @NotNull
    public AudioPostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    @Override
    public AudioFrame getLastFrame() {
        return this.lastFrame;
    }

    @Override
    public UUID getId() {
        return this.id;
    }
}

