/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.OpacityAudioFilter;

public class ReverbAudioFilter
extends OpacityAudioFilter {
    private int loops;
    private int interval;
    private short[] buffer;
    private int index;
    private int zeroLength;
    private boolean hasNewData = false;

    @Override
    public void preProcess(short[] samples, int offset, int length) {
        super.preProcess(samples, offset, length);
        if (this.buffer == null) {
            this.buffer = new short[this.interval * this.loops];
        }
        this.hasNewData = true;
        for (int i = offset; i < length; ++i) {
            this.zeroLength = 0;
            this.buffer[this.index] = samples[i];
            this.index = (this.index + 1) % this.buffer.length;
        }
    }

    @Override
    public void readStereoOverlay(short[] out, int samplesOffset, int length) {
        super.readStereoOverlay(out, samplesOffset, length);
        if (this.buffer == null) {
            return;
        }
        if (!this.hasNewData) {
            for (int i = 0; i < length / 2; ++i) {
                ++this.zeroLength;
                this.buffer[this.index] = 0;
                this.index = (this.index + 1) % this.buffer.length;
            }
        }
        int revLength = this.buffer.length;
        for (int sampleIndex = samplesOffset; sampleIndex < length; ++sampleIndex) {
            short sample = out[sampleIndex];
            int relativeIndex = (this.index + length + sampleIndex / 2 + revLength) % revLength;
            for (int loop = 1; loop <= this.loops; ++loop) {
                int offset = this.interval * loop;
                int index = (relativeIndex - offset + revLength) % revLength;
                float reverbSample = (float)this.buffer[index] / ((float)(loop * loop) / 10.0f + 1.0f) / 30.0f;
                if (sampleIndex % 2 == loop % 2) {
                    reverbSample /= 2.0f;
                }
                sample = (short)(sample + (short)(reverbSample * this.getOpacity()));
            }
            out[sampleIndex] = sample;
        }
        this.hasNewData = false;
    }

    @Override
    public boolean hasStereo() {
        return true;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.loops > 0 && this.interval > 0;
    }

    @Override
    public boolean canClose() {
        return !this.isActive() || this.buffer == null || this.zeroLength > this.buffer.length;
    }

    @Override
    public void reset() {
        this.buffer = null;
        this.index = 0;
        this.zeroLength = 0;
    }

    public void setLoops(int loops) {
        this.loops = loops;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

