/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client;

import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceChatClientListener;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.addons.voicechat.api.event.VoiceChatAuthenticatedEvent;
import net.labymod.addons.voicechat.api.event.VoiceChatDisconnectEvent;
import net.labymod.addons.voicechat.api.event.moderation.VoiceUserVisibilityChangedEvent;
import net.labymod.addons.voicechat.core.channel.DefaultChannelController;
import net.labymod.addons.voicechat.core.client.user.DefaultVoiceUser;
import net.labymod.addons.voicechat.core.util.VoiceChatSounds;
import net.labymod.api.Laby;
import net.labymod.api.client.chat.ChatExecutor;
import net.labymod.api.client.chat.Title;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.network.server.ServerData;
import net.labymod.api.client.session.Session;
import net.labymod.api.event.Event;
import net.labymod.api.models.Implements;
import net.labymod.api.notification.Notification;
import net.labymod.api.util.logging.Logging;
import net.labymod.voice.protocol.type.DisconnectType;
import net.labymod.voice.protocol.util.properties.ChannelProperties;
import net.labymod.voice.protocol.util.properties.UserProperties;

@Singleton
@Implements(value=VoiceChatClientListener.class)
public class DefaultVoiceChatClientListener
implements VoiceChatClientListener {
    private static final boolean DEBUG = false;
    private final VoiceChat voiceChat;
    private final VoiceUserRegistry voiceUserRegistry;
    private final DefaultChannelController channelController;
    private final Logging logging;
    private VoiceConnector connector;
    private AudioStreamRegistry streamRegistry;
    private String lastDisconnectMessage;
    private boolean authenticated;

    @Inject
    public DefaultVoiceChatClientListener(VoiceChat voiceChat, VoiceUserRegistry voiceUserRegistry, ChannelController channelController) {
        this.voiceChat = voiceChat;
        this.voiceUserRegistry = voiceUserRegistry;
        this.channelController = (DefaultChannelController)channelController;
        this.logging = Logging.create((String)"VoiceChat");
    }

    @Override
    public void onAuthenticated(boolean isStaff) {
        Session session;
        if (this.connector == null) {
            this.connector = this.voiceChat.referenceStorage().voiceConnector();
        }
        if ((session = this.connector.getSession()) == null) {
            throw new IllegalStateException("Session is null");
        }
        this.voiceUserRegistry.getOrCreate(session.getUniqueId());
        this.authenticated = true;
        ServerData serverData = Laby.references().serverController().getCurrentServerData();
        if (serverData != null) {
            this.connector.transmitter().sendNetworkSwitch(serverData.address());
        }
        Laby.fireEvent((Event)new VoiceChatAuthenticatedEvent(session, isStaff));
    }

    @Override
    public void onDisconnected(DisconnectType type, String reason) {
        this.lastDisconnectMessage = type.name() + ": " + reason;
        this.logging.info((CharSequence)(String.valueOf((Object)type) + ": " + reason), new Object[0]);
        this.authenticated = false;
        this.voiceUserRegistry.purge();
        Laby.fireEvent((Event)new VoiceChatDisconnectEvent(type, reason));
    }

    @Override
    public void onPlayerDiscovered(UUID uniqueId, JsonObject meta) {
        DefaultVoiceUser user = (DefaultVoiceUser)this.voiceUserRegistry.getOrCreate(uniqueId);
        try {
            user.setCommunicating(true);
            user.updateMeta(meta);
            Laby.fireEvent((Event)new VoiceUserVisibilityChangedEvent(user, true));
        }
        catch (Exception e) {
            this.logging.error((CharSequence)("Failed to update meta for " + String.valueOf(uniqueId) + ": " + meta.toString()), (Throwable)e);
        }
    }

    @Override
    public void onUpdateMeta(UUID uniqueId, JsonObject meta) {
        DefaultVoiceUser user = (DefaultVoiceUser)this.voiceUserRegistry.getOrCreate(uniqueId);
        try {
            user.updateMeta(meta);
        }
        catch (Exception e) {
            this.logging.error((CharSequence)("Failed to update meta for " + String.valueOf(uniqueId) + ": " + meta.toString()), (Throwable)e);
        }
    }

    @Override
    public void onPlayerDisappeared(UUID uniqueId) {
        VoiceUser voiceUser = this.voiceUserRegistry.get(uniqueId);
        if (voiceUser != null) {
            voiceUser.setCommunicating(false);
            Laby.fireEvent((Event)new VoiceUserVisibilityChangedEvent(voiceUser, false));
        }
    }

    @Override
    public void onAudioReceived(UUID uniqueId, byte[] data) {
        try {
            if (this.voiceChat.isTestingMicrophone()) {
                return;
            }
            DefaultVoiceUser user = (DefaultVoiceUser)this.voiceUserRegistry.get(uniqueId);
            if (user == null || user.isMutedForClient()) {
                return;
            }
            if (data == null || data.length < 8) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.wrap(data);
            long segmentNumber = buffer.getLong();
            byte[] encodedData = new byte[buffer.remaining()];
            buffer.get(encodedData);
            if (this.streamRegistry == null) {
                this.streamRegistry = this.voiceChat.referenceStorage().audioStreamRegistry();
            }
            this.streamRegistry.submit(uniqueId, encodedData, segmentNumber);
        }
        catch (Throwable e) {
            this.logging.error((CharSequence)("Failed to submit audio data for " + String.valueOf(uniqueId)), e);
        }
    }

    @Override
    public void onWarn(String reason) {
        ChatExecutor executor = Laby.labyAPI().minecraft().chatExecutor();
        executor.displayClientMessage(reason == null || reason.isEmpty() ? Component.translatable((String)"voicechat.commands.warn.receive", (Component[])new Component[0]).color(NamedTextColor.RED) : Component.translatable((String)"voicechat.commands.warn.receiveReason", (Component[])new Component[0]).argument((Component)Component.text((String)MuteTemplate.prettify(reason), (TextColor)NamedTextColor.YELLOW)).color(NamedTextColor.RED));
        executor.showTitle(new Title((Component)Component.empty(), Component.translatable((String)"voicechat.commands.warn.receiveTitle", (Component[])new Component[0]).color(NamedTextColor.RED), 10, 100, 10));
    }

    @Override
    public void onChannelShow(UUID channelId, ChannelProperties properties) {
        this.channelController.onChannelShow(channelId, properties);
    }

    @Override
    public void onChannelUpdate(UUID channelId, ChannelProperties properties) {
        this.channelController.onChannelUpdate(channelId, properties);
    }

    @Override
    public void onChannelHide(UUID channelId) {
        this.channelController.onChannelHide(channelId);
    }

    @Override
    public void onChannelReset() {
        this.channelController.onChannelReset();
    }

    @Override
    public void onUserShow(UUID userId, UUID channelId, UserProperties properties) {
        this.channelController.onUserShow(userId, channelId, properties);
    }

    @Override
    public void onUserSwitchChannel(UUID userId, UUID prevChannelId, UUID newChannelId, UserProperties properties) {
        this.channelController.onUserSwitchChannel(userId, prevChannelId, newChannelId, properties);
    }

    @Override
    public void onChannelUserUpdateProperties(UUID userId, UserProperties properties) {
        this.channelController.onChannelUserUpdateProperties(userId, properties);
    }

    @Override
    public void onUserHide(UUID userId, UUID channelId) {
        this.channelController.onUserHide(userId, channelId);
    }

    @Override
    public void onChannelAlert(String messageId, List<String> arguments) {
        Component[] components = (Component[])arguments.stream().map(Component::text).toArray(Component[]::new);
        Laby.labyAPI().notificationController().push(Notification.builder().title((Component)Component.translatable((String)"voicechat.activity.channels.alert.title", (Component[])new Component[0])).text((Component)Component.translatable((String)("voicechat.activity.channels.alert.type." + messageId), (Component[])new Component[0]).arguments(components)).build());
        Laby.labyAPI().minecraft().sounds().playSound(VoiceChatSounds.SOUND_CHANNEL_ALERT, 0.5f, 1.0f);
    }

    @Override
    public String getLastDisconnectMessage() {
        return this.lastDisconnectMessage;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }
}

