/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client.user.moderate;

import net.labymod.addons.voicechat.api.client.user.moderate.Mute;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.api.util.time.TimeUtil;

public class DefaultMute
implements Mute {
    private final long timeStart;
    private final long timeEnd;
    private final String reason;
    private final String mutedByName;
    private final String unmutedByName;
    private final String mainUsername;

    public DefaultMute(long timeStart, long timeEnd, String reason, String mutedByName, String unmutedByName, String mainUsername) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.reason = reason;
        this.mutedByName = mutedByName;
        this.unmutedByName = unmutedByName;
        this.mainUsername = mainUsername;
    }

    @Override
    public String getMutedByName() {
        return this.mutedByName == null ? "Unknown" : this.mutedByName;
    }

    @Override
    public String getUnmutedByName() {
        return this.unmutedByName == null ? "Nobody" : this.unmutedByName;
    }

    @Override
    public boolean isUnmutedManually() {
        return this.unmutedByName != null;
    }

    @Override
    public String getMainUsername() {
        return this.mainUsername;
    }

    @Override
    public boolean isServerApiMute() {
        return false;
    }

    @Override
    public String getReason() {
        return MuteTemplate.prettify(this.reason);
    }

    @Override
    public long getTimeStart() {
        return this.timeStart;
    }

    @Override
    public long getTimeEnd() {
        return this.timeEnd;
    }

    public static DefaultMute none() {
        return new DefaultMute(0L, 0L, null, null, null, null);
    }

    public static DefaultMute until(long timeEnd) {
        return new DefaultMute(TimeUtil.getCurrentTimeMillis(), timeEnd, null, null, null, null);
    }

    public static DefaultMute until(long muteTimeEnd, String reason) {
        return new DefaultMute(TimeUtil.getCurrentTimeMillis(), muteTimeEnd, reason, null, null, null);
    }
}

