/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.commands;

import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.core.util.User;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.util.io.web.result.ResultCallback;

@Singleton
public class VoiceWarnCommand
extends Command {
    private final VoiceChat voiceChat;
    private final VoiceConnector voiceConnector;

    @Inject
    public VoiceWarnCommand(VoiceChat voiceChat, VoiceConnector voiceConnector) {
        super("voicewarn", new String[0]);
        this.voiceChat = voiceChat;
        this.voiceConnector = voiceConnector;
        this.translationKey("voicechat.commands.warn");
    }

    public boolean execute(String prefix, String[] args) {
        if (!this.voiceConnector.isConnected() || !this.voiceConnector.isAuthenticated()) {
            this.displayTranslatable("notConnected", NamedTextColor.RED, new Component[0]);
            return true;
        }
        if (args.length == 0) {
            this.displaySyntax();
            return true;
        }
        User.loadAndBeautify(args[0], (ResultCallback<User>)((ResultCallback)result -> {
            if (!result.isPresent()) {
                this.displayTranslatable("notFound", NamedTextColor.RED, new Object[]{args[0]});
                return;
            }
            User user = (User)result.get();
            String reason = args.length > 1 ? String.join((CharSequence)" ", args).substring(args[0].length() + 1) : null;
            this.voiceConnector.transmitter().warnPlayer(user.getUniqueId(), reason);
            this.displayTranslatable("warned", NamedTextColor.GREEN, new Object[]{user.getUserName()});
        }));
        return true;
    }
}

