/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.listener;

import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.api.Laby;
import net.labymod.api.client.session.Session;
import net.labymod.api.client.session.SessionAccessor;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.addon.lifecycle.AddonPostEnableEvent;
import net.labymod.api.event.client.session.SessionUpdateEvent;

public class SessionListener {
    private final VoiceConnector client;
    private final SessionAccessor sessionAccessor;

    public SessionListener(DefaultReferenceStorage references) {
        this.client = references.voiceConnector();
        this.sessionAccessor = Laby.labyAPI().minecraft().sessionAccessor();
    }

    @Subscribe
    public void onSessionUpdate(SessionUpdateEvent event) {
        this.client.switchSession(event.newSession());
    }

    @Subscribe(value=126)
    public void onPostStartup(AddonPostEnableEvent event) {
        Session session = this.sessionAccessor.getSession();
        if (session != null) {
            this.client.switchSession(session);
        }
    }
}

