/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.snapshot;

import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.client.user.moderate.Report;
import net.labymod.addons.voicechat.api.snapshot.VoiceUserSnapshot;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.client.user.DefaultVoiceUser;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.laby3d.renderer.snapshot.AbstractLabySnapshot;
import net.labymod.api.laby3d.renderer.snapshot.Extras;
import org.jetbrains.annotations.Nullable;

public class DefaultVoiceUserSnapshot
extends AbstractLabySnapshot
implements VoiceUserSnapshot {
    private final boolean communicating;
    private final boolean stream;
    private final AudioStreamState streamState;
    private final boolean focused;
    private final Report report;
    private final int reportCount;
    private final VoiceUserSnapshot.ChannelInfo channelInfo;

    public DefaultVoiceUserSnapshot(Player player, Extras extras) {
        super(extras);
        VoiceChatAddon addon = VoiceChatAddon.INSTANCE;
        DefaultReferenceStorage storage = addon.referenceStorage();
        UUID uuid = player.getUniqueId();
        VoiceUserRegistry userRegistry = storage.voiceUserRegistry();
        this.communicating = userRegistry.isCommunicating(uuid);
        this.stream = storage.audioStreamRegistry().hasStream(uuid);
        this.streamState = storage.audioStreamRegistry().getState(uuid, false);
        this.focused = (Boolean)((DefaultVoiceChatConfiguration)addon.configuration()).enabled().get() != false && storage.focusedUsers().isFocused(uuid);
        VoiceUser user = userRegistry.get(uuid);
        this.channelInfo = this.createChannel(user, storage.channelController());
        boolean isUserInModView = user != null && (Boolean)((DefaultVoiceChatConfiguration)addon.configuration()).modView().get() != false;
        this.report = isUserInModView ? ((DefaultVoiceUser)user).getHighlightedReport() : null;
        this.reportCount = isUserInModView ? user.getReports().size() : 0;
    }

    private VoiceUserSnapshot.ChannelInfo createChannel(VoiceUser user, ChannelController channelController) {
        Channel channel;
        if (user == null) {
            return null;
        }
        UUID id = user.getChannelId();
        if (!user.isCommunicating() || id.equals(channelController.getCurrentChannelId())) {
            return null;
        }
        String channelName = user.getChannelName();
        if (id.equals(LobbyChannel.ID) && (channel = channelController.index().getChannelByChannelId(id)) != null) {
            channelName = channel.getName();
        }
        return new VoiceUserSnapshot.ChannelInfo(id, channelName);
    }

    @Override
    public boolean isCommunicating() {
        return this.communicating;
    }

    @Override
    public boolean hasStream() {
        return this.stream;
    }

    @Override
    public AudioStreamState getStreamState() {
        return this.streamState;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    @Nullable
    public Report getReport() {
        return this.report;
    }

    @Override
    public int getReportCount() {
        return this.reportCount;
    }

    @Override
    @Nullable
    public VoiceUserSnapshot.ChannelInfo getChannel() {
        return this.channelInfo;
    }
}

