/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.channel.widget;

import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.core.ui.activity.channel.widget.VoiceChannelWidget;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;

@AutoWidget
public class VoiceChannelListWidget
extends VerticalListWidget<VoiceChannelWidget> {
    private final ChannelController controller;

    public VoiceChannelListWidget(ChannelController controller, ListSession<VoiceChannelWidget> session) {
        super(session);
        this.controller = controller;
    }

    protected void updateContentBounds() {
        VoiceChannelWidget target = this.getTarget();
        boolean wasInView = target != null && this.isInView(target);
        super.updateContentBounds();
        if (wasInView && !this.isInView(target)) {
            this.scrollToWidget(target);
        }
    }

    public void scrollToWidget(VoiceChannelWidget widget) {
        Parent parent = this.getParent();
        if (parent == null) {
            return;
        }
        Bounds outer = parent.bounds();
        Bounds target = widget.bounds();
        float scrollY = this.session.getScrollPositionY();
        float targetCenterY = target.getCenterY() - scrollY;
        float outerCenterY = outer.getCenterY();
        float delta = targetCenterY - outerCenterY;
        for (int i = 0; i < 10; ++i) {
            this.session.scroll(delta / 10.0f);
            if (this.isInView(widget)) break;
        }
    }

    public boolean isInView(VoiceChannelWidget widget) {
        Parent parent = this.getParent();
        if (parent == null) {
            return false;
        }
        Bounds outer = parent.bounds();
        Bounds target = widget.bounds();
        float scrollY = this.session.getScrollPositionY();
        return target.getTop() - scrollY >= outer.getTop() && target.getBottom() - scrollY <= outer.getBottom();
    }

    public boolean isTarget(VoiceChannelWidget widget) {
        return widget.getChannel().getId().equals(this.controller.getCurrentChannelId());
    }

    public VoiceChannelWidget getTarget() {
        for (VoiceChannelWidget child : this.children) {
            if (!this.isTarget(child)) continue;
            return child;
        }
        return null;
    }
}

