/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.channel.widget;

import java.util.Locale;
import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.addons.voicechat.core.ui.activity.user.VoiceChatUserActivity;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.context.ContextMenu;
import net.labymod.api.client.gui.screen.widget.context.ContextMenuEntry;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.models.OperatingSystem;
import net.labymod.api.util.CountryCode;
import net.labymod.api.util.TextFormat;
import net.labymod.voice.protocol.util.properties.ChannelProperties;

@AutoWidget
public class VoiceChannelUserWidget
extends HorizontalListWidget {
    private final Channel channel;
    private final ChannelUser channelUser;
    private final VoiceUser voiceUser;

    public VoiceChannelUserWidget(Channel channel, ChannelUser user) {
        VoiceChatAddon voiceChat = VoiceChatAddon.INSTANCE;
        DefaultReferenceStorage reference = voiceChat.referenceStorage();
        this.channel = channel;
        this.channelUser = user;
        this.voiceUser = reference.voiceUserRegistry().getOrCreate(user.getId());
        VoiceConnector connector = reference.voiceConnector();
        VoiceTransmitter transmitter = connector.transmitter();
        this.addId("user");
        if (!user.isClient()) {
            ContextMenu menu = this.createContextMenu();
            menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.manage", (Component[])new Component[0])).clickHandler(entry -> {
                Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new VoiceChatUserActivity(voiceChat, user.getName(), user.getId()));
                return true;
            }).build());
            menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"labymod.activity.interactionMenu.entry.labynetProfile", (Component[])new Component[0])).clickHandler(entry -> {
                OperatingSystem.getPlatform().openUrl(String.format(Locale.ROOT, "https://laby.net/@%s", user.getName()));
                return true;
            }).build());
            if (!user.isFriend()) {
                menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.addFriend", (Component[])new Component[0])).clickHandler(entry -> {
                    LabyConnectSession session = Laby.labyAPI().labyConnect().getSession();
                    if (session != null) {
                        session.sendFriendRequest(user.getName());
                    }
                    return true;
                }).build());
            }
            if (channel.hasClientPermission()) {
                menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.kick", (Component[])new Component[0])).clickHandler(entry -> {
                    transmitter.sendMovePlayerToChannel(this.channelUser.getId(), LobbyChannel.ID);
                    return true;
                }).build());
                menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.ban", (Component[])new Component[0])).clickHandler(entry -> {
                    channel.properties().ban(this.channelUser.getId());
                    transmitter.sendMovePlayerToChannel(this.channelUser.getId(), LobbyChannel.ID);
                    transmitter.sendUpdateChannel(channel.getId(), channel.properties());
                    return true;
                }).build());
                if (!this.channel.isOwner(this.channelUser)) {
                    ChannelProperties channelProperties = this.channel.properties();
                    if (!channelProperties.hasTalkPower()) {
                        if (channelProperties.canTalk(this.channelUser.getId())) {
                            menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.revokeTalkPower", (Component[])new Component[0])).clickHandler(entry -> {
                                channel.properties().removeTalker(this.channelUser.getId());
                                transmitter.sendUpdateChannel(channel.getId(), channel.properties());
                                return true;
                            }).build());
                        } else {
                            menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.grantTalkPower", (Component[])new Component[0])).clickHandler(entry -> {
                                channel.properties().addTalker(this.channelUser.getId());
                                transmitter.sendUpdateChannel(channel.getId(), channel.properties());
                                return true;
                            }).build());
                        }
                    }
                    menu.addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.context.promote", (Component[])new Component[0])).clickHandler(entry -> {
                        channel.properties().setOwner(this.channelUser.getId());
                        transmitter.sendUpdateChannel(channel.getId(), channel.properties());
                        return true;
                    }).build());
                }
            }
        }
    }

    public void initialize(Parent parent) {
        CountryCode countryCode;
        super.initialize(parent);
        IconWidget headWidget = new IconWidget(Icon.head((UUID)this.channelUser.getId()));
        headWidget.addId("head");
        this.addEntry((Widget)headWidget);
        AudioStreamState state = this.channelUser.getAudioStreamState(true);
        if (state != null) {
            if (state == AudioStreamState.IN_ANOTHER_CHANNEL) {
                state = AudioStreamState.NOT_TALKING;
            }
            IconWidget stateIconWidget = new IconWidget(state.getIcon());
            stateIconWidget.addId("state");
            String id = TextFormat.SNAKE_CASE.toLowerCamelCase(state.name());
            stateIconWidget.setHoverComponent((Component)Component.translatable((String)("voicechat.activity.channels.talkState." + id), (Component[])new Component[0]));
            this.addEntry((Widget)stateIconWidget);
        }
        Component nameComponent = this.channelUser.getDisplayName();
        ComponentWidget nameWidget = ComponentWidget.component((Component)nameComponent);
        nameWidget.addId("name");
        this.addEntry((Widget)nameWidget);
        String code = this.channelUser.properties().getCountryCode();
        CountryCode countryCode2 = countryCode = code == null ? null : CountryCode.fromCode((String)code);
        if (countryCode != null && !(this.channel instanceof LobbyChannel)) {
            IconWidget languageWidget = new IconWidget(countryCode.getIcon());
            languageWidget.addId(new String[]{"language", "badge"});
            languageWidget.setHoverComponent((Component)Component.text((String)countryCode.getPrimaryName()));
            this.addEntry((Widget)languageWidget);
        }
        if (!this.channel.properties().hasTalkPower()) {
            boolean canTalk = this.channel.properties().canTalk(this.channelUser.getId());
            IconWidget talkPowerWidget = new IconWidget(canTalk ? VoiceChatTextures.SpriteCommon.CHANNEL_TALK_POWER_GRANTED : VoiceChatTextures.SpriteCommon.CHANNEL_TALK_POWER_REVOKED);
            talkPowerWidget.addId(new String[]{"talkPower", "badge"});
            talkPowerWidget.setHoverComponent((Component)Component.translatable((String)("voicechat.activity.channels.badges.talkPower" + (canTalk ? "Granted" : "Revoked")), (Component[])new Component[0]));
            this.addEntry((Widget)talkPowerWidget);
        }
        if (this.channelUser.isFriend()) {
            IconWidget friendWidget = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_FRIEND);
            friendWidget.addId(new String[]{"friend", "badge"});
            friendWidget.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.badges.friend", (Component[])new Component[0]));
            this.addEntry((Widget)friendWidget);
        }
        if (this.channel.isOwner(this.channelUser)) {
            IconWidget ownerWidget = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_OWNER);
            ownerWidget.addId(new String[]{"owner", "badge"});
            ownerWidget.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.badges.owner", (Component[])new Component[0]));
            this.addEntry((Widget)ownerWidget);
        }
        VoiceChatAddon voiceChat = VoiceChatAddon.INSTANCE;
        DefaultReferenceStorage reference = voiceChat.referenceStorage();
        ChannelController channelController = reference.channelController();
        boolean isClientInSameChannel = this.channel.getId().equals(channelController.getCurrentChannelId());
        boolean isVisible = !this.channel.properties().isProximity() || this.voiceUser.isVisibleInProximity() || !isClientInSameChannel;
        this.opacity().set((Object)Float.valueOf(isVisible ? 1.0f : 0.5f));
    }

    public int getSortingValue() {
        return this.channel.users().sorted().indexOf(this.channelUser);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelUser getChannelUser() {
        return this.channelUser;
    }

    public VoiceUser getVoiceUser() {
        return this.voiceUser;
    }
}

