/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.badge;

import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.api.client.entity.player.badge.renderer.BadgeRenderer;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.network.NetworkPlayerInfo;

public class VoiceBadge
extends BadgeRenderer {
    private final VoiceChatAddon voiceChatAddon;
    private final VoiceConnector voiceClient;
    private final VoiceUserRegistry voiceUserRegistry;
    private final AudioStreamRegistry audioStreamRegistry;
    private final ChannelController channelController;

    public VoiceBadge(VoiceChatAddon voiceChatAddon, VoiceConnector voiceClient, VoiceUserRegistry voiceUserRegistry, AudioStreamRegistry audioStreamRegistry) {
        this.voiceChatAddon = voiceChatAddon;
        this.voiceClient = voiceClient;
        this.voiceUserRegistry = voiceUserRegistry;
        this.audioStreamRegistry = audioStreamRegistry;
        this.channelController = voiceChatAddon.referenceStorage().channelController();
    }

    public void render(ScreenContext context, float x, float y, NetworkPlayerInfo player) {
        AudioStreamState state = this.audioStreamRegistry.getState(player.profile().getUniqueId(), false);
        context.canvas().submitIcon(state.getIcon(), x + 2.0f, y, 8.0f, 8.0f);
    }

    public boolean isVisible(NetworkPlayerInfo player) {
        if (this.voiceChatAddon.isTestingMicrophone()) {
            return false;
        }
        return this.voiceUserRegistry.isCommunicating(player.profile().getUniqueId());
    }

    protected boolean begin(ScreenContext context) {
        return (Boolean)((DefaultVoiceChatConfiguration)this.voiceChatAddon.configuration()).enabled().get() != false && (Boolean)((DefaultVoiceChatConfiguration)this.voiceChatAddon.configuration()).tabListIndicator().get() != false && this.voiceClient.isConnected();
    }
}

