/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.overlay;

import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.event.channel.UserUpdateEvent;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamShutdownEvent;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamStartEvent;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.ui.activity.channel.VoiceChannelsActivity;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.LabyScreen;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.overlay.ScreenOverlay;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.gui.screen.ActivityInitializeEvent;
import net.labymod.api.event.client.network.server.ServerJoinEvent;
import net.labymod.api.util.ThreadSafe;

@Link(value="menu-overlay.lss")
@AutoActivity
public class MenuVoiceButtonOverlay
extends ScreenOverlay {
    private final ChannelController channelController;
    private final Minecraft minecraft;
    private final AudioStreamRegistry streamRegistry;
    private Class<?> ingameMenuOverlayClass = null;
    private ButtonWidget indicatorButton;

    public MenuVoiceButtonOverlay(ChannelController channelController) {
        super(20);
        this.channelController = channelController;
        this.minecraft = this.labyAPI.minecraft();
        this.streamRegistry = VoiceChatAddon.INSTANCE.referenceStorage().audioStreamRegistry();
        try {
            this.ingameMenuOverlayClass = Class.forName("net.labymod.core.client.gui.screen.activity.activities.menu.IngameMenuOverlay");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.setActive(false);
        this.labyAPI.eventBus().registerListener((Object)this);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.indicatorButton = ButtonWidget.icon((Icon)AudioStreamState.NOT_TALKING.getIcon());
        this.indicatorButton.addId("menu-voice-button");
        this.indicatorButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.buttons.menuIndicator", (Component[])new Component[0]));
        this.indicatorButton.setPressable(() -> this.minecraft.minecraftWindow().displayScreen((ScreenInstance)new VoiceChannelsActivity()));
        ((Document)this.document).addChild((Widget)this.indicatorButton);
        this.updateIndicator();
    }

    public void updateVisibility() {
        boolean visible;
        LabyScreen screen = this.minecraft.minecraftWindow().currentLabyScreen();
        boolean bl = visible = !this.minecraft.isIngame() && this.channelController.isInCustomChannel() && !(screen instanceof VoiceChannelsActivity);
        if (this.isActive() == visible) {
            return;
        }
        ThreadSafe.executeOnRenderThread(() -> this.setActive(visible));
    }

    private void updateIndicator() {
        ThreadSafe.executeOnRenderThread(() -> {
            AudioStreamState state = this.streamRegistry.getClientState(true);
            if (state.isTalking()) {
                this.indicatorButton.addId("talking");
            } else {
                this.indicatorButton.removeId("talking");
            }
            this.indicatorButton.updateIcon(state.getIcon());
        });
    }

    @Subscribe
    public void onChannelClientPropertiesUpdate(UserUpdateEvent event) {
        if (this.channelController.isInCustomChannel() && this.isActive()) {
            this.updateIndicator();
        }
    }

    @Subscribe
    public void onAudioStreamStart(AudioStreamStartEvent event) {
        if (this.channelController.isInCustomChannel() && this.isActive()) {
            this.updateIndicator();
        }
    }

    @Subscribe
    public void onAudioStreamShutdown(AudioStreamShutdownEvent event) {
        if (this.channelController.isInCustomChannel() && this.isActive()) {
            this.updateIndicator();
        }
    }

    @Subscribe
    public void onActivityInitialize(ActivityInitializeEvent event) {
        this.updateVisibility();
        if (this.ingameMenuOverlayClass != null && this.ingameMenuOverlayClass.isAssignableFrom(event.activity().getClass())) {
            Document document = (Document)event.activity().document();
            VoiceConnector connector = VoiceChatAddon.INSTANCE.referenceStorage().voiceChat().client();
            ButtonWidget voiceChannelsButton = new ButtonWidget();
            voiceChannelsButton.addId("voicechannels-button");
            voiceChannelsButton.icon().set((Object)VoiceChatTextures.SpriteCommon.CHANNEL_OUTPUT);
            voiceChannelsButton.setEnabled(connector.isConnected() && connector.isAuthenticated());
            voiceChannelsButton.updateComponent((Component)Component.translatable((String)"voicechat.activity.channels.title", (Component[])new Component[0]));
            voiceChannelsButton.setPressable(() -> this.minecraft.minecraftWindow().displayScreen((ScreenInstance)new VoiceChannelsActivity()));
            Widget child = document.getChild("button-container-right");
            if (child instanceof HorizontalListWidget) {
                HorizontalListWidget list = (HorizontalListWidget)child;
                list.addEntryInitialized((Widget)voiceChannelsButton);
            }
        }
    }

    @Subscribe
    public void onServerJoin(ServerJoinEvent event) {
        this.updateVisibility();
    }

    @Subscribe
    public void onChannelUserUpdate(UserUpdateEvent event) {
        this.updateVisibility();
    }
}

