/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.tag;

import java.util.Collections;
import java.util.List;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.api.snapshot.VoiceExtraKeys;
import net.labymod.addons.voicechat.api.snapshot.VoiceUserSnapshot;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.tag.tags.ComponentNameTag;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import org.jetbrains.annotations.NotNull;

public class ChannelTag
extends ComponentNameTag {
    private final VoiceChat voiceChat;

    public ChannelTag(VoiceChat voiceChat) {
        this.voiceChat = voiceChat;
    }

    @NotNull
    protected List<Component> buildComponents(EntitySnapshot snapshot) {
        if (!snapshot.has(VoiceExtraKeys.VOICE_USER)) {
            return super.buildComponents(snapshot);
        }
        VoiceChatConfiguration config = this.voiceChat.configuration();
        if (!((Boolean)config.enabled().get()).booleanValue()) {
            return super.buildComponents(snapshot);
        }
        if (!((Boolean)config.channelIndicatorBelowName().get()).booleanValue()) {
            return super.buildComponents(snapshot);
        }
        VoiceUserSnapshot voiceUser = (VoiceUserSnapshot)this.snapshot.get(VoiceExtraKeys.VOICE_USER);
        VoiceUserSnapshot.ChannelInfo channel = voiceUser.getChannel();
        if (channel == null) {
            return super.buildComponents(snapshot);
        }
        String channelName = channel.name();
        if (channelName == null) {
            return Collections.singletonList(Component.translatable((String)"voicechat.tag.channel.unknown", (TextColor)NamedTextColor.AQUA));
        }
        return Collections.singletonList(Component.translatable((String)"voicechat.tag.channel.known", (TextColor)NamedTextColor.AQUA, (Component[])new Component[]{Component.text((String)channelName, (TextColor)NamedTextColor.WHITE)}));
    }

    public float getScale() {
        return 0.4f;
    }
}

