/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.javaxsound;

import java.util.Arrays;
import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice3D;
import net.labymod.addons.voicechat.api.audio.device.util.ChannelType;
import net.labymod.addons.voicechat.javaxsound.JavaxOutputDevice;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.vector.DoubleVector3;
import org.jetbrains.annotations.NotNull;

public class JavaxOutputDevice3D
extends JavaxOutputDevice
implements OutputDevice3D {
    private short[] samples;
    private int bufferSize;
    private DoubleVector3 position;
    private float yaw;
    private float referenceDistance;
    private float rolloffFactor;
    private float maxDistance;

    public JavaxOutputDevice3D(@NotNull DeviceInformation information) {
        super(information);
    }

    @Override
    public void prepare(DoubleVector3 position, float yaw, int bufferSize) {
        this.position = position;
        this.yaw = yaw;
        this.bufferSize = bufferSize;
        int channels = this.information.getFormat().getChannels();
        int size = bufferSize * channels;
        if (this.samples == null || this.samples.length != size) {
            this.samples = new short[size];
        } else {
            Arrays.fill(this.samples, (short)0);
        }
    }

    @Override
    public boolean isSourceWriteable(UUID id) {
        return true;
    }

    @Override
    public void writeSource(UUID id, ChannelType type, short[] in, int offset, int length, double volume) {
        this.writeSource(type, in, offset, length, volume, volume);
    }

    @Override
    public void writeSource(UUID id, ChannelType type, short[] in, int offset, int length, double volume, DoubleVector3 sourcePosition) {
        double distanceToPlayer = Math.sqrt(MathHelper.distanceSquared((double)sourcePosition.getX(), (double)sourcePosition.getY(), (double)sourcePosition.getZ(), (double)this.position.getX(), (double)this.position.getY(), (double)this.position.getZ()));
        double distance = MathHelper.clamp((double)distanceToPlayer, (double)this.referenceDistance, (double)this.maxDistance);
        double distanceVolume = Math.pow(distance / (double)this.referenceDistance, -this.rolloffFactor);
        double rotationRadians = distanceToPlayer == 0.0 ? 1.5707963267948966 : (double)MathHelper.radiansToTarget((float)this.yaw, (double)this.position.getX(), (double)this.position.getZ(), (double)sourcePosition.getX(), (double)sourcePosition.getZ());
        double cos = Math.cos(rotationRadians);
        double strengthLeft = MathHelper.clamp((double)(1.0 - cos), (double)0.0, (double)1.0) * distanceVolume;
        double strengthRight = MathHelper.clamp((double)(1.0 + cos), (double)0.0, (double)1.0) * distanceVolume;
        this.writeSource(type, in, offset, length, strengthLeft * volume, strengthRight * volume);
    }

    private void writeSource(ChannelType type, short[] in, int offset, int length, double volumeLeft, double volumeRight) {
        if (length != this.bufferSize * type.getChannels()) {
            throw new IllegalArgumentException("Length of input buffer does not match buffer size");
        }
        if (type == ChannelType.MONO) {
            for (int i = 0; i < length; ++i) {
                int n = i * 2;
                this.samples[n] = (short)(this.samples[n] + (short)((double)in[offset + i] * volumeLeft));
                int n2 = i * 2 + 1;
                this.samples[n2] = (short)(this.samples[n2] + (short)((double)in[offset + i] * volumeRight));
            }
        } else {
            for (int i = 0; i < length; i += 2) {
                int n = i;
                this.samples[n] = (short)(this.samples[n] + (short)((double)in[offset + i] * volumeLeft));
                int n3 = i + 1;
                this.samples[n3] = (short)(this.samples[n3] + (short)((double)in[offset + i + 1] * volumeRight));
            }
        }
    }

    @Override
    public void upload() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        this.write(this.samples, 0, this.samples.length);
    }

    @Override
    public long getProcessIntervalMs() {
        return 10L;
    }

    @Override
    public void setReferenceDistance(float referenceDistance) {
        this.referenceDistance = referenceDistance;
    }

    @Override
    public void setRolloffFactor(float rolloffFactor) {
        this.rolloffFactor = rolloffFactor;
    }

    @Override
    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }
}

