/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.exception.DeviceException;
import net.labymod.addons.voicechat.api.audio.device.io.AbstractDevice;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice3D;
import net.labymod.addons.voicechat.api.audio.device.util.ChannelType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.openal.api.ALBufferedSource;
import net.labymod.addons.voicechat.openal.api.ALContext;
import net.labymod.addons.voicechat.openal.api.ALSource;
import net.labymod.addons.voicechat.openal.api.ALSpeaker;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.vector.DoubleVector3;
import net.labymod.api.util.math.vector.FloatVector3;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.NotNull;

public class OpenALOutputDevice
extends AbstractDevice
implements OutputDevice3D {
    private final Map<UUID, ALBufferedSource> sources = new HashMap<UUID, ALBufferedSource>();
    private final Map<UUID, Long> timestamps = new HashMap<UUID, Long>();
    private ALSpeaker speaker;
    private ALContext context;
    private final int sampleRate;
    private final int bufferSize;
    private DoubleVector3 position;
    private FloatVector3 direction;
    private float maxDistance;
    private float referenceDistance;
    private float rolloffFactor;

    public OpenALOutputDevice(@NotNull DeviceInformation information) {
        super(information);
        Format format = information.getFormat();
        this.sampleRate = format.getSampleRate();
        this.bufferSize = format.getBufferSizeForMs((int)this.getProcessIntervalMs());
    }

    @Override
    public void open(Format format, int bufferSize) throws DeviceException {
        if (this.isOpen()) {
            throw new DeviceException(this, "Device is already open");
        }
        this.speaker = new ALSpeaker();
        boolean success = this.speaker.open(this.information.getIdentifier().getDeviceId());
        if (!success) {
            this.logging.error((CharSequence)("Failed to find target device " + String.valueOf(this.information.getIdentifier()) + ", using default"), new Object[0]);
            success = this.speaker.open(ALSpeaker.getDefaultName());
            if (!success) {
                throw new DeviceException(this, "Couldn't find any device with the specified format: " + String.valueOf(format));
            }
        }
        try {
            this.context = new ALContext(this.speaker);
        }
        catch (IOException e) {
            throw new DeviceException(this, e.getMessage());
        }
        super.open(format, bufferSize);
    }

    @Override
    public void prepare(int bufferSize) {
        this.prepare(false, VECTOR_ZERO, 0.0f, bufferSize);
    }

    @Override
    public void prepare(DoubleVector3 position, float yaw, int bufferSize) {
        this.prepare(true, position, yaw, bufferSize);
    }

    private void prepare(boolean stereo, DoubleVector3 position, float yaw, int bufferSize) {
        this.context.setThreadContext();
        double yawRad = MathHelper.toRadiansDouble((double)(yaw + 90.0f));
        this.direction = new FloatVector3(MathHelper.cos((double)yawRad), 0.0f, MathHelper.sin((double)yawRad));
        this.position = position;
        for (ALBufferedSource bufSource : this.sources.values()) {
            bufSource.resetDirty();
        }
    }

    @Override
    public boolean isSourceWriteable(UUID id) {
        ALBufferedSource bufferedSource = this.sources.get(id);
        return bufferedSource == null || bufferedSource.isWriteable();
    }

    @Override
    public void writeSource(UUID id, ChannelType type, short[] in, int offset, int length, double volume, DoubleVector3 sourcePosition) {
        ALBufferedSource source = this.sources.computeIfAbsent(id, uuid -> {
            ALBufferedSource bufSrc = new ALBufferedSource(this.sampleRate, this.bufferSize, 32, 1, type);
            ALSource sourceRef = bufSrc.source();
            sourceRef.setLooping(false);
            sourceRef.setDistanceModel(ALSource.DistanceModel.EXPONENT_CLAMPED);
            sourceRef.setMinGain(0.0f);
            return bufSrc;
        });
        ALSource sourceRef = source.source();
        if (!sourceRef.exists()) {
            return;
        }
        sourceRef.setRolloffFactor(this.rolloffFactor);
        sourceRef.setMaxDistance(this.maxDistance);
        sourceRef.setReferenceDistance(this.referenceDistance);
        sourceRef.setGain((float)volume * 4.0f);
        sourceRef.setMaxGain((float)volume * 4.0f);
        source.setListenerOrientation(this.direction);
        source.setListenerPosition(this.position);
        source.setPosition(sourcePosition);
        source.write(type, in, offset, length);
        this.checkTimeout(id);
    }

    private void checkTimeout(UUID id) {
        this.timestamps.put(id, TimeUtil.getCurrentTimeMillis());
        this.timestamps.entrySet().removeIf(entry -> {
            ALBufferedSource removed;
            boolean remove;
            long time = (Long)entry.getValue();
            boolean bl = remove = TimeUtil.getCurrentTimeMillis() - time > 300000L;
            if (remove && (removed = this.sources.remove(entry.getKey())) != null && removed.exists()) {
                removed.delete();
            }
            return remove;
        });
    }

    @Override
    public void upload() {
        for (ALBufferedSource bufSource : this.sources.values()) {
            if (!bufSource.source().exists() || bufSource.isDirty()) continue;
            bufSource.unqueueProcessedBuffers();
            if (!bufSource.isIdle()) continue;
            bufSource.flush();
            bufSource.source().play();
        }
        this.context.releaseThreadContext();
    }

    @Override
    public void writeSource(UUID id, ChannelType type, short[] in, int offset, int length, double volume) {
        this.writeSource(id, type, in, offset, length, volume, this.position);
    }

    @Override
    public void write(short[] in, int offset, int length) {
        throw new UnsupportedOperationException("Use writeSource instead");
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        super.close();
        if (this.isOpen()) {
            for (ALBufferedSource source : this.sources.values()) {
                if (!source.exists()) continue;
                source.delete();
            }
            this.sources.clear();
            this.timestamps.clear();
            this.context.destroy();
            this.speaker.close();
        }
        this.speaker = null;
    }

    @Override
    public boolean isOpen() {
        return this.speaker != null && this.speaker.isOpen() && this.context != null && !this.context.isDestroyed();
    }

    @Override
    public long getProcessIntervalMs() {
        return 20L;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public void setReferenceDistance(float referenceDistance) {
        this.referenceDistance = referenceDistance;
    }

    @Override
    public void setRolloffFactor(float rolloffFactor) {
        this.rolloffFactor = rolloffFactor;
    }
}

