/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal.api;

import net.labymod.api.util.logging.Logging;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC11;

public class ALError {
    private static final Logging LOGGING = Logging.getLogger();

    public static boolean checkAL() {
        int error = AL11.alGetError();
        if (error == 0) {
            return false;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement callType = stackTrace[2];
        StackTraceElement callPosition = stackTrace[3];
        String apiName = callType.getFileName() == null ? "Unknown" : callType.getFileName().replace(".java", "");
        LOGGING.error((CharSequence)("OpenAL error: " + ALError.getALError(error) + " at " + apiName + "." + callType.getMethodName() + "(" + callPosition.getFileName() + ":" + callPosition.getLineNumber() + ")"), new Object[0]);
        return true;
    }

    public static boolean checkALC(long device) {
        int error = ALC11.alcGetError((long)device);
        if (error == 0) {
            return false;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement callType = stackTrace[2];
        StackTraceElement callPosition = stackTrace[3];
        String apiName = callType.getFileName() == null ? "Unknown" : callType.getFileName().replace(".java", "");
        LOGGING.error((CharSequence)("OpenALC error: " + ALError.getALCError(error) + " at " + apiName + "." + callType.getMethodName() + "(" + callPosition.getFileName() + ":" + callPosition.getLineNumber() + ")"), new Object[0]);
        return true;
    }

    private static String getALError(int code) {
        return switch (code) {
            case 40961 -> "Invalid name";
            case 40962 -> "Invalid enum";
            case 40963 -> "Invalid value";
            case 40964 -> "Invalid operation";
            case 40965 -> "Out of memory";
            default -> "Unknown error";
        };
    }

    public static String getALCError(int code) {
        return switch (code) {
            case 40961 -> "Invalid device";
            case 40962 -> "Invalid context";
            case 40963 -> "Invalid enum";
            case 40964 -> "Invalid value";
            case 40965 -> "Out of memory";
            default -> "Unknown error";
        };
    }
}

