/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.device;

import java.util.Objects;
import net.labymod.addons.voicechat.api.audio.device.AudioInterface;
import net.labymod.addons.voicechat.api.audio.device.Device;
import net.labymod.addons.voicechat.api.audio.device.DeviceIdentifier;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import org.jetbrains.annotations.NotNull;

public class DeviceInformation {
    private final AudioInterface audioInterface;
    private final DeviceIdentifier identifier;
    private final String displayName;
    private final DeviceType type;
    private final Format format;

    public DeviceInformation(AudioInterface audioInterface, String identifier, String displayName, DeviceType type, Format format) {
        this.audioInterface = audioInterface;
        this.identifier = new DeviceIdentifier(audioInterface, identifier);
        this.displayName = displayName;
        this.type = type;
        this.format = format;
    }

    @NotNull
    public AudioInterface getAudioInterface() {
        return this.audioInterface;
    }

    @NotNull
    public DeviceIdentifier getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public DeviceType getType() {
        return this.type;
    }

    public Format getFormat() {
        return this.format;
    }

    public Device create() {
        return this.audioInterface.createDevice(this);
    }

    public String toString() {
        return this.identifier.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInformation that = (DeviceInformation)o;
        return Objects.equals(this.audioInterface, that.audioInterface) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.displayName, that.displayName) && this.type == that.type && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.audioInterface, this.identifier, this.displayName, this.type, this.format});
    }
}

