/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.channel.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.util.Identifiable;

public class Index<T extends Identifiable> {
    private final Map<UUID, T> map = new HashMap<UUID, T>();
    private final List<T> list = new ArrayList<T>();
    private final Comparator<T> comparator;
    private List<T> sorted;
    private boolean dirty;

    public Index(Comparator<T> comparator) {
        this.comparator = comparator;
        this.sorted = new ArrayList<T>();
        this.dirty = false;
    }

    public void add(T entry) {
        if (this.map.containsKey(entry.getId())) {
            throw new IllegalArgumentException("Object with id " + String.valueOf(entry.getId()) + " already exists");
        }
        this.map.put(entry.getId(), entry);
        this.list.add(entry);
        this.dirty = true;
    }

    public void remove(T entry) {
        Identifiable remove = (Identifiable)this.map.remove(entry.getId());
        if (remove == null) {
            throw new IllegalArgumentException("Object with id " + String.valueOf(entry.getId()) + " does not exist");
        }
        this.list.remove(remove);
        this.dirty = true;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
        this.dirty = true;
    }

    public T getById(UUID id) {
        return (T)((Identifiable)this.map.get(id));
    }

    public T removeById(UUID id) {
        Identifiable entry = (Identifiable)this.map.remove(id);
        if (entry == null) {
            throw new IllegalArgumentException("Object with id " + String.valueOf(id) + " does not exist");
        }
        this.list.remove(entry);
        this.dirty = true;
        return (T)entry;
    }

    public List<T> unsorted() {
        return this.list;
    }

    public List<T> sorted() {
        if (this.dirty) {
            ArrayList<T> sorted = new ArrayList<T>(this.list);
            sorted.sort(this.comparator);
            this.sorted = sorted;
            this.dirty = false;
        }
        return this.sorted;
    }

    public int size() {
        return this.list.size();
    }

    public T getAtUnsorted(int index) {
        return (T)((Identifiable)this.list.get(index));
    }

    public T getAtSorted(int index) {
        return (T)((Identifiable)this.sorted().get(index));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void setDirty() {
        this.dirty = true;
    }
}

