/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.rnnoise;

import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.audio.noise.NoiseFilter;
import net.labymod.addons.voicechat.api.audio.noise.NoiseFilterFactory;
import net.labymod.addons.voicechat.core.audio.rnnoise.RNNoiseFilter;
import net.labymod.api.Constants;
import net.labymod.api.models.Implements;
import net.labymod.api.models.OperatingSystem;
import net.labymod.api.util.io.IOUtil;

@Singleton
@Implements(value=NoiseFilterFactory.class)
public class RNNoiseFactory
implements NoiseFilterFactory {
    private boolean initialized;

    @Override
    public void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        String resourcePath = this.getResourcePath();
        Path path = Constants.Files.NATIVES.resolve("voicechat").resolve(resourcePath.replace("/", "-"));
        if (!IOUtil.exists((Path)path)) {
            InputStream resource = this.getResource(resourcePath);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(resource, path, new CopyOption[0]);
            resource.close();
        }
        System.load(path.toAbsolutePath().toString());
        this.initialized = true;
    }

    @Override
    public NoiseFilter create() {
        if (!this.initialized) {
            throw new IllegalStateException("Factory not initialized");
        }
        return new RNNoiseFilter();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private String getResourcePath() {
        OperatingSystem platform = OperatingSystem.getPlatform();
        String prefix = platform.getLibraryPrefix();
        String suffix = "." + platform.getLibraryExtensionName();
        String os = platform.getName();
        String arch = switch (platform.getArch()) {
            case "i386", "i486", "i586", "i686", "x86", "x86_32" -> "x86";
            case "amd64", "x86_64", "x86-64" -> "x64";
            case "aarch64" -> "aarch64";
            default -> platform.getArch();
        };
        return "%s/%s".formatted(os + "-" + arch, prefix + "rnnoise" + suffix);
    }

    private InputStream getResource(String resourcePath) {
        InputStream stream = this.getClass().getResourceAsStream("/natives/" + resourcePath);
        if (stream == null) {
            throw new IllegalStateException("Resource not found: " + resourcePath);
        }
        return stream;
    }
}

