/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AbstractAudioFilter;
import net.labymod.api.util.time.TimeUtil;

public abstract class OpacityAudioFilter
extends AbstractAudioFilter {
    private float opacity;
    private float previousOpacity;
    private long lastTimeSet;
    private long duration;

    public void setOpacity(float opacity) {
        this.setOpacity(opacity, 0L);
    }

    public void setOpacity(float opacity, long duration) {
        if (this.opacity == opacity) {
            return;
        }
        this.previousOpacity = this.opacity;
        this.opacity = opacity;
        this.lastTimeSet = TimeUtil.getCurrentTimeMillis();
        this.duration = duration;
    }

    public float getOpacity() {
        if (this.duration <= 0L) {
            return this.opacity;
        }
        long currentTime = TimeUtil.getCurrentTimeMillis();
        long timePassed = currentTime - this.lastTimeSet;
        if (timePassed >= this.duration) {
            return this.opacity;
        }
        float progress = (float)timePassed / (float)this.duration;
        return this.previousOpacity + (this.opacity - this.previousOpacity) * progress;
    }

    @Override
    public boolean isActive() {
        return this.getOpacity() > 0.0f;
    }
}

