/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AbstractAudioFilter;

public class CompressionAudioFilter
extends AbstractAudioFilter {
    private boolean active;
    private float threshold;
    private double ratio;

    @Override
    public void preProcess(short[] samples, int offset, int length) {
        for (int i = 0; i < samples.length; ++i) {
            double sample = (float)samples[i] / 32768.0f;
            if (Math.abs(sample) > (double)this.threshold) {
                sample = Math.signum(sample) * ((double)this.threshold + (Math.abs(sample) - (double)this.threshold) / this.ratio);
            }
            samples[i] = (short)(sample * 32768.0);
        }
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isActive() {
        return this.active && this.threshold > 0.0f && this.ratio > 0.0;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }
}

