/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.OpacityAudioFilter;
import net.labymod.api.util.math.MathHelper;

public class LowPassAudioFilter
extends OpacityAudioFilter {
    private double amount;
    private boolean initialized = false;
    private short smoothedSample;

    @Override
    public void preProcess(short[] samples, int offset, int length) {
        if (!this.initialized) {
            this.smoothedSample = 0;
            this.initialized = true;
        }
        double fade = MathHelper.clamp((double)(this.amount - 1.0), (double)0.0, (double)1.0);
        double opacity = fade * (double)this.getOpacity();
        for (int i = offset; i < length; ++i) {
            short sample = samples[i];
            this.smoothedSample = (short)(this.smoothedSample + (short)((double)(sample - this.smoothedSample) / Math.max(this.amount, 2.0)));
            samples[i] = (short)((double)sample * (1.0 - opacity) + (double)this.smoothedSample * opacity);
        }
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.amount > 0.0;
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void reset() {
        this.initialized = false;
        this.smoothedSample = 0;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }
}

