/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.channel.channel;

import java.util.Locale;
import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.channel.util.Index;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.voice.protocol.util.properties.ChannelProperties;

public abstract class AbstractChannel
implements Channel {
    protected final UUID id;
    protected Index<ChannelUser> users = new Index((user1, user2) -> {
        int priority2;
        int priority1 = user1.getPriorityForChannel(this);
        if (priority1 != (priority2 = user2.getPriorityForChannel(this))) {
            return Integer.compare(priority2, priority1);
        }
        return user1.getName().toLowerCase(Locale.ENGLISH).compareTo(user2.getName().toLowerCase(Locale.ENGLISH));
    });
    protected ChannelProperties properties = new ChannelProperties();

    public AbstractChannel(UUID id) {
        this.id = id;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Index<ChannelUser> users() {
        return this.users;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractChannel that = (AbstractChannel)obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void removeUser(UUID userId) {
        this.users.removeById(userId);
    }

    public void addUser(ChannelUser user) {
        this.users.add(user);
    }

    @Override
    public ChannelProperties properties() {
        return this.properties;
    }

    @Override
    public boolean isDefault() {
        return this.getId().equals(LobbyChannel.ID);
    }

    @Override
    public boolean hasSounds() {
        return true;
    }

    public void update(ChannelProperties properties) {
        this.properties = properties;
        this.users.setDirty();
    }
}

