/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.commands;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.addons.voicechat.core.ui.activity.user.VoiceChatUserActivity;
import net.labymod.addons.voicechat.core.util.User;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.util.io.web.result.ResultCallback;

public class VoiceReportCommand
extends Command {
    private final VoiceChat voiceChat;
    private final VoiceConnector voiceConnector;

    public VoiceReportCommand(VoiceChat voiceChat, VoiceConnector voiceConnector) {
        super("voicereport", new String[0]);
        this.voiceChat = voiceChat;
        this.voiceConnector = voiceConnector;
        this.translationKey("voicechat.commands.report");
    }

    public boolean execute(String prefix, String[] args) {
        if (!this.voiceConnector.isConnected() || !this.voiceConnector.isAuthenticated()) {
            this.displayTranslatable("notConnected", NamedTextColor.RED, new Component[0]);
            return true;
        }
        if (args.length == 0) {
            this.displaySyntax();
            return true;
        }
        User.loadAndBeautify(args[0], (ResultCallback<User>)((ResultCallback)result -> {
            if (!result.isPresent()) {
                this.displayTranslatable("notFound", NamedTextColor.RED, new Object[]{args[0]});
                return;
            }
            User user = (User)result.get();
            UUID uniqueId = user.getUniqueId();
            String userName = user.getUserName();
            if (userName == null) {
                this.displayTranslatable("notFound", NamedTextColor.RED, new Object[]{uniqueId.toString()});
                return;
            }
            if (args.length == 1) {
                this.labyAPI.minecraft().executeNextTick(() -> {
                    VoiceChatUserActivity activity = new VoiceChatUserActivity(this.voiceChat, userName, uniqueId);
                    activity.setReportingContext(true);
                    this.openActivity((ScreenInstance)activity);
                });
                return;
            }
            String reason = String.join((CharSequence)" ", args).substring(args[0].length() + 1);
            MuteTemplate muteTemplate = MuteTemplate.fromDisplayName(reason);
            if (muteTemplate == null) {
                muteTemplate = MuteTemplate.fromIdentifier(reason);
            }
            if (muteTemplate == null) {
                String validReasons = Arrays.stream(MuteTemplate.values()).map(MuteTemplate::getDisplayName).collect(Collectors.joining(", "));
                this.displayTranslatable("invalidReason", NamedTextColor.RED, new Object[]{reason, validReasons});
            } else {
                this.voiceConnector.transmitter().reportPlayer(uniqueId, muteTemplate);
                this.displayTranslatable("reported", NamedTextColor.RED, new Object[]{userName, muteTemplate.getDisplayName()});
            }
        }));
        return true;
    }
}

