/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.commands;

import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.core.util.User;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.util.io.web.result.ResultCallback;

public class VoiceUnmuteCommand
extends Command {
    private final VoiceConnector voiceConnector;

    public VoiceUnmuteCommand(VoiceConnector voiceConnector) {
        super("voiceunmute", new String[0]);
        this.voiceConnector = voiceConnector;
        this.translationKey("voicechat.commands.unmute");
    }

    public boolean execute(String prefix, String[] args) {
        if (!this.voiceConnector.isConnected() || !this.voiceConnector.isAuthenticated()) {
            this.displayTranslatable("notConnected", NamedTextColor.RED, new Component[0]);
            return true;
        }
        if (args.length != 1) {
            this.displaySyntax();
            return true;
        }
        if (!this.voiceConnector.isStaff()) {
            this.displayTranslatable("unmuted", NamedTextColor.RED, new Object[]{args[0]});
        }
        User.load(args[0], (ResultCallback<User>)((ResultCallback)result -> {
            if (!result.isPresent()) {
                this.displayTranslatable("notFound", NamedTextColor.RED, new Object[]{args[0]});
                return;
            }
            this.voiceConnector.transmitter().unmutePlayer(((User)result.get()).getUniqueId());
            this.displayTranslatable("admin.unmuted", NamedTextColor.RED, new Object[]{args[0]});
        }));
        return true;
    }
}

